/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.wizard.ResourceTypeWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ResourceTypeWizard
extends Wizard
implements INewWizard {
    ResourceTypeWizardPage page;
    IResourceTypeService rtService;
    ResourceType resourceType;

    public ResourceTypeWizard() {
        this.setWindowTitle("Create Resource Type");
        this.rtService = ServiceFactory.createFactory().createResourceTypeService();
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public boolean performFinish() {
        block5: {
            block4: {
                try {
                    if (this.rtService.isResourceTypeNameUnique(this.page.getResourceTypeName())) break block4;
                    this.page.setErrorMessage("A Resource Type with this name already exists");
                    return false;
                }
                catch (Exception e) {
                    Utility.reportError("Resource Type Creation Failed.", e);
                    return false;
                }
            }
            if (this.rtService.isResourceTypeSystemIdUnique(this.page.getResourceTypeSystemID())) break block5;
            this.page.setErrorMessage("A Resource Type with this System ID already exists");
            return false;
        }
        ResourceType newResourceType = new ResourceType();
        newResourceType.setName(this.page.getResourceTypeName());
        newResourceType.setSystemId(this.page.getResourceTypeSystemID());
        newResourceType.setDescription(this.page.getResourceTypeDescription());
        newResourceType.setConnectionType(this.page.getConnectionType());
        this.resourceType = this.rtService.createResourceType(newResourceType);
        return true;
    }

    public void init(IWorkbench arg0, IStructuredSelection arg1) {
    }

    public void addPages() {
        this.page = new ResourceTypeWizardPage();
        this.addPage((IWizardPage)this.page);
    }
}

