/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import com.tandbergtv.watchpoint.studio.dto.ConnectionType;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.util.UIValidator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ResourceTypeWizardPage
extends WizardPage {
    private Text nameText;
    private Text systemIDText;
    private Text descText;
    private Combo connTypeCombo;
    private ModifyListener validationListener;
    private IResourceTypeService rtService;
    private Map<String, ConnectionType> connTypesNameObjMap = new HashMap<String, ConnectionType>();
    private boolean validationEnabled = false;

    public ResourceTypeWizardPage() {
        super("Resource Type");
        this.setTitle("Create Resource Type");
        this.setDescription("Create a new Resource Type");
        this.validationListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResourceTypeWizardPage.this.validate();
            }
        };
        this.rtService = ServiceFactory.createFactory().createResourceTypeService();
    }

    public String getResourceTypeName() {
        return this.convertEmptyToNull(this.nameText.getText());
    }

    public String getResourceTypeSystemID() {
        return this.convertEmptyToNull(this.systemIDText.getText());
    }

    public String getResourceTypeDescription() {
        return this.convertEmptyToNull(this.descText.getText());
    }

    public ConnectionType getConnectionType() {
        return this.connTypesNameObjMap.get(this.connTypeCombo.getText());
    }

    public boolean isPageComplete() {
        return this.getErrorMessage() == null && this.nameText.getText().length() > 0;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = this.createClientArea(parent);
        this.createCustomControls(composite);
        this.setValuesAndState();
        this.validationEnabled = true;
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    private Composite createClientArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private void createCustomControls(Composite parent) {
        Label nameLabel = new Label(parent, 0);
        nameLabel.setText("Name : ");
        this.nameText = new Text(parent, 2048);
        this.nameText.setTextLimit(50);
        this.nameText.addModifyListener(this.validationListener);
        Label systemIDLabel = new Label(parent, 0);
        systemIDLabel.setText("System ID : ");
        this.systemIDText = new Text(parent, 2048);
        this.systemIDText.setTextLimit(2);
        this.systemIDText.addModifyListener(this.validationListener);
        Label descLabel = new Label(parent, 0);
        descLabel.setText("Description : ");
        this.descText = new Text(parent, 2818);
        this.descText.setTextLimit(256);
        this.descText.addModifyListener(this.validationListener);
        Label connTypeLabel = new Label(parent, 0);
        connTypeLabel.setText("Connection Type : ");
        this.connTypeCombo = new Combo(parent, 780);
        this.connTypeCombo.addModifyListener(this.validationListener);
        FormData nameTextFD = new FormData();
        nameTextFD.left = new FormAttachment(30, 2);
        nameTextFD.right = new FormAttachment(100, -10);
        this.nameText.setLayoutData((Object)nameTextFD);
        FormData systemIDLabelFD = new FormData();
        systemIDLabelFD.top = new FormAttachment((Control)this.nameText, 10);
        systemIDLabel.setLayoutData((Object)systemIDLabelFD);
        FormData systemIDTextFD = new FormData();
        systemIDTextFD.top = new FormAttachment((Control)this.nameText, 10);
        systemIDTextFD.left = new FormAttachment(30, 2);
        systemIDTextFD.right = new FormAttachment(100, -10);
        this.systemIDText.setLayoutData((Object)systemIDTextFD);
        FormData descLabelFD = new FormData();
        descLabelFD.top = new FormAttachment((Control)this.systemIDText, 10);
        descLabel.setLayoutData((Object)descLabelFD);
        FormData descTextFD = new FormData();
        descTextFD.left = new FormAttachment(30, 2);
        descTextFD.top = new FormAttachment((Control)this.systemIDText, 10);
        descTextFD.right = new FormAttachment(100, -10);
        descTextFD.bottom = new FormAttachment((Control)this.connTypeCombo, -10);
        this.descText.setLayoutData((Object)descTextFD);
        FormData connTypeLabelFD = new FormData();
        connTypeLabelFD.top = new FormAttachment((Control)this.descText, 10);
        connTypeLabel.setLayoutData((Object)connTypeLabelFD);
        FormData connTypeComboFD = new FormData();
        connTypeComboFD.left = new FormAttachment(30, 2);
        connTypeComboFD.right = new FormAttachment(100, -10);
        connTypeComboFD.bottom = new FormAttachment(100, -10);
        this.connTypeCombo.setLayoutData((Object)connTypeComboFD);
    }

    private void setValuesAndState() {
        List<ConnectionType> connTypes = this.rtService.getAllConnectionTypes();
        if (connTypes != null && !connTypes.isEmpty()) {
            for (ConnectionType connType : connTypes) {
                this.connTypeCombo.add(connType.getName());
                this.connTypesNameObjMap.put(connType.getName(), connType);
            }
            this.connTypeCombo.select(0);
        }
    }

    private void validate() {
        if (!this.validationEnabled) {
            return;
        }
        String errorMessage = null;
        errorMessage = UIValidator.validateValue("Name", this.nameText.getText(), UIValidator.Validation.NOT_BLANK, UIValidator.Validation.TRIMMED);
        if (errorMessage != null) {
            this.updateErrorMessage(errorMessage);
            return;
        }
        errorMessage = UIValidator.validateValue("System ID", this.systemIDText.getText(), UIValidator.Validation.NOT_BLANK, UIValidator.Validation.TRIMMED, UIValidator.Validation.ALPHA_NUMERIC);
        if (errorMessage != null) {
            this.updateErrorMessage(errorMessage);
            return;
        }
        errorMessage = UIValidator.validateValue("Description", this.descText.getText(), UIValidator.Validation.TRIMMED);
        if (errorMessage != null) {
            this.updateErrorMessage(errorMessage);
            return;
        }
        this.updateErrorMessage(null);
    }

    private void updateErrorMessage(String errorMessage) {
        this.setErrorMessage(errorMessage);
        this.getContainer().updateButtons();
    }

    private String convertEmptyToNull(String str) {
        return str.length() == 0 ? null : str;
    }
}

