/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class SelectFilesAndDirsPage
extends WizardPage {
    private static final String EMPTY_STRING = "";
    private String[] filterExtensions;
    private boolean dirsAllowed;
    private String labelText;
    private List listBox;

    public SelectFilesAndDirsPage(String pageName, boolean dirsAllowed) {
        super(pageName);
        this.dirsAllowed = dirsAllowed;
        this.setLabel(EMPTY_STRING);
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.filterExtensions = filterExtensions;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public void setLabel(String label) {
        this.labelText = label != null ? label : EMPTY_STRING;
    }

    public String getLabel() {
        return this.labelText;
    }

    public String[] getItems() {
        return this.listBox.getItems();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = this.createClientArea(parent);
        this.createFilesAndDirsControl(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    private Composite createClientArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private void createFilesAndDirsControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(this.labelText);
        this.listBox = new List(parent, 2818);
        Button addFilesButton = new Button(parent, 8);
        addFilesButton.setText("Add Files");
        addFilesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] stringArray = SelectFilesAndDirsPage.this.getFilePathsFromUser();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String filePath = stringArray[n2];
                    SelectFilesAndDirsPage.this.listBox.add(filePath);
                    ++n2;
                }
            }
        });
        Button addDirButton = null;
        if (this.dirsAllowed) {
            addDirButton = new Button(parent, 8);
            addDirButton.setText("Add Folder");
            addDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String dirPath = SelectFilesAndDirsPage.this.getDirPathFormUser();
                    if (dirPath != null && dirPath.trim().length() > 0) {
                        SelectFilesAndDirsPage.this.listBox.add(dirPath);
                    }
                }
            });
        }
        Button removeButton = new Button(parent, 8);
        removeButton.setText("Remove");
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectFilesAndDirsPage.this.listBox.remove(SelectFilesAndDirsPage.this.listBox.getSelectionIndices());
            }
        });
        FormData labelFD = new FormData();
        labelFD.left = new FormAttachment(0);
        label.setLayoutData((Object)labelFD);
        FormData listBoxFD = new FormData();
        listBoxFD.top = new FormAttachment((Control)label, 10);
        listBoxFD.left = new FormAttachment(0);
        listBoxFD.right = new FormAttachment(100, -10);
        listBoxFD.bottom = new FormAttachment((Control)addFilesButton, -10);
        this.listBox.setLayoutData((Object)listBoxFD);
        FormData addFileButtonFD = new FormData();
        addFileButtonFD.bottom = new FormAttachment(100);
        addFileButtonFD.left = new FormAttachment(0);
        addFilesButton.setLayoutData((Object)addFileButtonFD);
        if (addDirButton != null) {
            FormData addDirButtonFD = new FormData();
            addDirButtonFD.bottom = new FormAttachment(100);
            addDirButtonFD.left = new FormAttachment((Control)addFilesButton, 5);
            addDirButton.setLayoutData((Object)addDirButtonFD);
        }
        FormData removeButtonFD = new FormData();
        removeButtonFD.bottom = new FormAttachment(100);
        removeButtonFD.left = new FormAttachment((Control)(addDirButton != null ? addDirButton : addFilesButton), 5);
        removeButton.setLayoutData((Object)removeButtonFD);
    }

    private String[] getFilePathsFromUser() {
        FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 131074);
        fileDialog.setText("Select File(s)");
        if (this.filterExtensions != null) {
            fileDialog.setFilterExtensions(this.filterExtensions);
        }
        fileDialog.open();
        String[] filePaths = new String[fileDialog.getFileNames().length];
        int index = 0;
        String[] stringArray = fileDialog.getFileNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            filePaths[index++] = String.valueOf(fileDialog.getFilterPath()) + File.separator + fileName;
            ++n2;
        }
        return filePaths;
    }

    private String getDirPathFormUser() {
        DirectoryDialog dirDialog = new DirectoryDialog(Display.getCurrent().getActiveShell(), 131072);
        dirDialog.setText("Select Folder");
        return dirDialog.open();
    }
}

