/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.external.wpexport.ExportFailureException;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.wizard.ExportSelectDirPage;
import com.tandbergtv.watchpoint.studio.ui.wizard.SelectFilesAndDirsPage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WPDTOExportWizard<WPO extends IWatchPointDTO>
extends Wizard {
    private WPO dtoObject;
    private ExportSelectDirPage exportDirPage;
    private SelectFilesAndDirsPage classesPage;
    private SelectFilesAndDirsPage resourcesPage;
    private SelectFilesAndDirsPage librariesPage;

    public WPDTOExportWizard(WPO dtoObject) {
        this.dtoObject = dtoObject;
        this.exportDirPage = new ExportSelectDirPage("Export Folder");
        this.exportDirPage.setTitle("Export Folder");
        this.exportDirPage.setDescription("Select the export folder");
        this.exportDirPage.setLabel("Folder:");
    }

    public boolean performFinish() {
        HashMap<String, Object> exportInputAttrs = new HashMap<String, Object>();
        exportInputAttrs.put("exportFolderPath", this.exportDirPage.getSelectedDir());
        exportInputAttrs.put("deleteFolderContents", true);
        exportInputAttrs.put("classFilePathList", Arrays.asList(this.classesPage.getItems()));
        exportInputAttrs.put("resourceFilePathList", Arrays.asList(this.resourcesPage.getItems()));
        exportInputAttrs.put("jarFilePathList", Arrays.asList(this.librariesPage.getItems()));
        try {
            this.export(this.dtoObject, exportInputAttrs);
            MessageDialog.openInformation((Shell)super.getShell(), (String)"Export", (String)"Export was successful.");
            return true;
        }
        catch (Exception e) {
            Utility.reportError("Export Failed", e);
            return false;
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.exportDirPage);
        this.classesPage = new SelectFilesAndDirsPage("Classes", true);
        this.classesPage.setTitle("Classes");
        this.classesPage.setDescription("Select classes to include in export");
        this.classesPage.setLabel("Class Files and Directories:");
        this.addPage((IWizardPage)this.classesPage);
        this.resourcesPage = new SelectFilesAndDirsPage("Resources", true);
        this.resourcesPage.setTitle("Resources");
        this.resourcesPage.setDescription("Select resources to include in export");
        this.resourcesPage.setLabel("Resource Files and Directories:");
        this.addPage((IWizardPage)this.resourcesPage);
        this.librariesPage = new SelectFilesAndDirsPage("Libraries", false);
        this.librariesPage.setTitle("Libraries");
        this.librariesPage.setDescription("Select libraries to include in export");
        this.librariesPage.setLabel("Library Files:");
        this.addPage((IWizardPage)this.librariesPage);
    }

    protected abstract void export(WPO var1, Map<String, Object> var2) throws ExportFailureException;
}

