/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.xml;

import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.jpdl.model.AbstractNode;
import org.jbpm.gd.jpdl.model.Description;
import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.ExceptionHandler;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.Transition;

public class NodeDefinitionDomAdapter
extends XmlAdapter {
    public void initialize(SemanticElement jpdlElement) {
        super.initialize(jpdlElement);
        NodeDefinition nodeDefinition = (NodeDefinition)jpdlElement;
        if (this.getAttribute("name") != null && !this.getAttribute("name").equals("")) {
            nodeDefinition.setName(this.getAttribute("name"));
        }
        nodeDefinition.setDefinitionName(this.getAttribute("definitionName"));
        if (this.getAttribute("resourceType") != null && !this.getAttribute("resourceType").equals("")) {
            nodeDefinition.setResourceType(Long.parseLong(this.getAttribute("resourceType")));
        }
        if (this.getAttribute("id") != null && !this.getAttribute("id").equals("")) {
            nodeDefinition.setId(Long.parseLong(this.getAttribute("id")));
        }
        nodeDefinition.addPropertyChangeListener((PropertyChangeListener)((Object)this));
    }

    public Map getNodeTypes() {
        Map types = super.getNodeTypes();
        types.put("auto-task", "node-element");
        types.put("super-state", "node-element");
        types.put("transition", "transition");
        types.put("variable", "variable");
        types.put("description", "description");
        return types;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("auto-task".equals(evt.getPropertyName())) {
            this.setElement("auto-task", (SemanticElement)evt.getOldValue(), (SemanticElement)evt.getNewValue());
        } else if ("super-state".equals(evt.getPropertyName())) {
            this.setElement("super-state", (SemanticElement)evt.getOldValue(), (SemanticElement)evt.getNewValue());
        } else if ("transitionAdd".equals(evt.getPropertyName())) {
            this.addElement((SemanticElement)((Transition)evt.getNewValue()));
        } else if ("transitionRemove".equals(evt.getPropertyName())) {
            this.removeElement((SemanticElement)((Transition)evt.getOldValue()));
        } else if ("name".equals(evt.getPropertyName())) {
            this.setAttribute("name", (String)evt.getNewValue());
        } else if ("resourceType".equals(evt.getPropertyName())) {
            this.setAttribute("resourceType", evt.getNewValue().toString());
        } else if ("definitionName".equals(evt.getPropertyName())) {
            this.setAttribute("definitionName", (String)evt.getNewValue());
        } else if ("id".equals(evt.getPropertyName())) {
            this.setAttribute("id", evt.getNewValue().toString());
        } else if ("variableAdd".equals(evt.getPropertyName())) {
            this.addElement((SemanticElement)((WPVariable)((Object)evt.getNewValue())));
        } else if ("variableRemove".equals(evt.getPropertyName())) {
            this.removeElement((SemanticElement)((WPVariable)((Object)evt.getOldValue())));
        } else if ("description".equals(evt.getPropertyName())) {
            this.setElement("description", (SemanticElement)evt.getOldValue(), (SemanticElement)((Description)evt.getNewValue()));
        }
    }

    protected void initialize() {
        super.initialize();
        if (this.getSemanticElement() != null) {
            NodeDefinition nodeDefinition = (NodeDefinition)this.getSemanticElement();
            this.setAttribute("name", nodeDefinition.getName());
            this.setAttribute("definitionName", nodeDefinition.getDefinitionName());
            this.setAttribute("id", String.valueOf(nodeDefinition.getId()));
            this.setAttribute("resourceType", String.valueOf(nodeDefinition.getResourceType()));
            this.addElements((SemanticElement[])nodeDefinition.getNodeElements());
            if (nodeDefinition.getNode() instanceof NodeElementContainer) {
                List<WPVariable> variables = nodeDefinition.getVariables();
                this.addElements((SemanticElement[])variables.toArray(new WPVariable[variables.size()]));
            }
            this.addElements((SemanticElement[])nodeDefinition.getTransitions());
            this.addElement((SemanticElement)nodeDefinition.getDescription());
        }
    }

    protected void doModelAdd(XmlAdapter child) {
        String type = child.getElementType();
        SemanticElement jpdlElement = this.createSemanticElementFor(child);
        child.initialize(jpdlElement);
        NodeDefinition nodeDefinition = (NodeDefinition)this.getSemanticElement();
        if ("event".equals(type)) {
            nodeDefinition.addEvent((Event)jpdlElement);
        } else if ("exception-handler".equals(type)) {
            nodeDefinition.addExceptionHandler((ExceptionHandler)jpdlElement);
        } else if ("transition".equals(type)) {
            nodeDefinition.addTransition((Transition)jpdlElement);
        } else if ("auto-task".equals(type) || "super-state".equals(type)) {
            nodeDefinition.setNode((AbstractNode)jpdlElement);
        } else if ("description".equals(this.getNodeType(type))) {
            nodeDefinition.setDescription((Description)jpdlElement);
        } else if ("transition".equals(type)) {
            nodeDefinition.addTransition((Transition)jpdlElement);
        } else if ("variable".equals(type)) {
            nodeDefinition.addVariable((WPVariable)jpdlElement);
        } else if ("description".equals(this.getNodeType(type))) {
            nodeDefinition.setDescription((Description)jpdlElement);
        }
    }

    protected void doModelRemove(XmlAdapter child) {
        String type = child.getElementType();
        NodeDefinition nodeDefinition = (NodeDefinition)this.getSemanticElement();
        if ("transition".equals(type)) {
            nodeDefinition.removeTransition((Transition)child.getSemanticElement());
        } else if ("description".equals(this.getNodeType(type))) {
            nodeDefinition.setDescription(null);
        }
    }

    protected void doModelUpdate(String name, String newValue) {
        NodeDefinition nodeDefinition = (NodeDefinition)this.getSemanticElement();
        if ("name".equals(name)) {
            nodeDefinition.setName(newValue);
        } else if ("resourceType".equals(name)) {
            nodeDefinition.setResourceType(Long.parseLong(newValue));
        } else if ("definitionName".equals(name)) {
            nodeDefinition.setDefinitionName(newValue);
        }
    }
}

