/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.xml;

import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.jbpm.gd.jpdl.model.Script;
import org.jbpm.gd.jpdl.xml.ScriptDomAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WPScriptDomAdapter
extends ScriptDomAdapter {
    private static final String PADDING = "\t";
    private static final String INTER_CHILD_SPACING = "\n";

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (2 == eventType) {
            this.handleDomAdd(newValue);
        } else if (3 == eventType) {
            this.handleDomRemove(oldValue);
        } else if (changedFeature != null) {
            this.doModelUpdate(((Node)changedFeature).getNodeName(), (String)newValue);
        }
    }

    protected void doModelUpdate(String name, String newValue) {
        Script script = (Script)this.getSemanticElement();
        if ("#cdata-section".equals(name)) {
            String content = this.getTextContent();
            script.setScript(content);
        } else if ("#text".equals(name)) {
            String content = this.getTextContent();
            this.replaceScriptContent(content);
            script.setScript(content);
        } else {
            super.doModelUpdate(name, newValue);
        }
    }

    protected void setTextContent(String content) {
        String oldContent = this.getTextContent();
        if (content == null) {
            content = "";
        }
        if (content.equals(oldContent)) {
            return;
        }
        this.replaceScriptContent(content);
    }

    private void replaceScriptContent(String content) {
        this.removeTextChildren();
        this.replaceTextChild(content);
    }

    private void removeTextChildren() {
        NodeList list = this.getNode().getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            short nodeType = list.item(i).getNodeType();
            if (nodeType == 3 || nodeType == 4) {
                this.getNode().removeChild(list.item(i--));
            }
            ++i;
        }
    }

    private void replaceTextChild(String content) {
        Node node = this.getNode();
        Document document = node.getOwnerDocument();
        if (content != null && !content.equals("")) {
            int level = this.getNodeLevel();
            node.appendChild(document.createTextNode(this.getElementSpacingString(level)));
            node.appendChild(document.createCDATASection(content));
            node.appendChild(document.createTextNode(this.getElementSpacingString(level - 1)));
        }
    }

    private int getNodeLevel() {
        int result = 0;
        Node node = this.getNode();
        Document document = node.getOwnerDocument();
        while (node != null && node != document) {
            ++result;
            node = node.getParentNode();
        }
        return result;
    }

    private String getElementSpacingString(int level) {
        StringBuilder result = new StringBuilder();
        result.append(INTER_CHILD_SPACING);
        int i = 0;
        while (i < level) {
            result.append(PADDING);
            ++i;
        }
        return result.toString();
    }
}

