/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.xml;

import com.tandbergtv.watchpoint.studio.ui.model.ProtectionKey;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import java.beans.PropertyChangeEvent;
import java.util.Map;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.jpdl.model.AbstractNode;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.xml.ProcessDefinitionDomAdapter;

public class WorkflowTemplateDomAdapter
extends ProcessDefinitionDomAdapter {
    public Map getNodeTypes() {
        Map types = super.getNodeTypes();
        types.put("nodeDefinition", "node-element");
        types.put("auto-task", "node-element");
        types.put("manual-task", "node-element");
        types.put("protection-key", "protection-key");
        return types;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("pkAdd".equals(evt.getPropertyName())) {
            this.addElement((SemanticElement)((ProtectionKey)((Object)evt.getNewValue())));
        } else if ("pkRemove".equals(evt.getPropertyName())) {
            this.removeElement((SemanticElement)((ProtectionKey)((Object)evt.getOldValue())));
        } else if ("version".equals(evt.getPropertyName())) {
            this.setAttribute("version", evt.getNewValue().toString());
        } else {
            super.propertyChange(evt);
        }
    }

    protected void doModelUpdate(String name, String newValue) {
        WorkflowTemplate template = (WorkflowTemplate)this.getSemanticElement();
        if ("version".equals(name)) {
            template.setVersion(Integer.parseInt(newValue));
        } else {
            super.doModelUpdate(name, newValue);
        }
    }

    protected void doModelAdd(XmlAdapter child) {
        String type = child.getElementType();
        SemanticElement jpdlElement = this.createSemanticElementFor(child);
        if (jpdlElement == null) {
            return;
        }
        WorkflowTemplate template = (WorkflowTemplate)this.getSemanticElement();
        if ("protection-key".equals(type)) {
            child.initialize(jpdlElement);
            template.addProtectionKey((ProtectionKey)jpdlElement);
        } else if ("auto-task".equals(type) || "manual-task".equals(type) || "nodeDefinition".equals(type)) {
            child.initialize(jpdlElement);
            template.addNodeElement((NodeElement)((AbstractNode)jpdlElement));
        } else {
            super.doModelAdd(child);
        }
    }

    protected void doModelRemove(XmlAdapter child) {
        String type = child.getElementType();
        WorkflowTemplate template = (WorkflowTemplate)this.getSemanticElement();
        if ("protection-key".equals(type)) {
            template.removeProtectionKey((ProtectionKey)child.getSemanticElement());
        } else if ("auto-task".equals(type) || "manual-task".equals(type) || "nodeDefinition".equals(type) || "node-element".equals(type)) {
            template.removeNodeElement((NodeElement)((AbstractNode)child.getSemanticElement()));
        } else {
            super.doModelRemove(child);
        }
    }
}

