/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.usermgmt;

import com.tandbergtv.watchpoint.studio.usermgmt.IUserIdGenerator;
import com.tandbergtv.watchpoint.studio.usermgmt.User;
import com.tandbergtv.watchpoint.studio.usermgmt.UserManagementException;

public class DefaultUserIdGenerator
implements IUserIdGenerator {
    private static final String Token = "#";

    public User generateUser(String userId) throws UserManagementException {
        String[] values;
        if (!(userId == null && "".equals(userId) || (values = userId.split(Token)).length != 4)) {
            String id = values[0];
            String ipAddr = values[1];
            long timeStamp = Long.parseLong(values[2]);
            int randomNum = Integer.parseInt(values[3]);
            return new User(id, ipAddr, timeStamp, randomNum);
        }
        throw new UserManagementException("Failed to generate User from UserId");
    }

    public String generateUserId(User user) throws UserManagementException {
        StringBuffer userId = new StringBuffer();
        if (user.getUserName() == null) {
            throw new UserManagementException("Username can not be null");
        }
        userId.append(user.getUserName());
        userId.append(Token);
        if (user.getIpAddress() == null) {
            throw new UserManagementException("IP Address can not be null");
        }
        userId.append(user.getIpAddress());
        userId.append(Token);
        userId.append(user.getTimeStamp());
        userId.append(Token);
        userId.append(user.getRandomNumber());
        return userId.toString();
    }
}

