/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.usermgmt;

import com.tandbergtv.watchpoint.studio.usermgmt.DefaultUserIdGenerator;
import com.tandbergtv.watchpoint.studio.usermgmt.IUserIdGenerator;
import com.tandbergtv.watchpoint.studio.usermgmt.User;
import com.tandbergtv.watchpoint.studio.usermgmt.UserManagementException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;
import org.apache.log4j.Logger;

public class UserManager {
    private static final Logger logger = Logger.getLogger(UserManager.class);
    private static UserManager instance;
    private User currentUser = this.createUser();
    private IUserIdGenerator idGenerator = new DefaultUserIdGenerator();

    private UserManager() {
    }

    public static UserManager getInstance() {
        if (instance == null) {
            instance = new UserManager();
        }
        return instance;
    }

    private User createUser() {
        String userId = System.getProperty("user.name");
        InetAddress addr = null;
        String ipAddr = "";
        try {
            addr = InetAddress.getLocalHost();
            ipAddr = addr.getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.error((Object)("Unable to get the IP Address:  " + e.getMessage()));
        }
        User user = new User(userId, ipAddr, System.currentTimeMillis(), new Random().nextInt());
        return user;
    }

    public User getCurrentUser() {
        return this.currentUser;
    }

    public String getCurrentUserId() throws UserManagementException {
        return this.idGenerator.generateUserId(this.currentUser);
    }

    public String getUserId(User user) throws UserManagementException {
        return this.idGenerator.generateUserId(user);
    }

    public User getUser(String userId) throws UserManagementException {
        return this.idGenerator.generateUser(userId);
    }
}

