/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.util;

import com.tandbergtv.watchpoint.studio.application.StudioRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassLoaderUtil {
    private ClassLoaderUtil() {
    }

    public static <T> T createFactoryInstance(String factoryClassName, Class<T> factoryType) {
        try {
            Class<?> clazz = Class.forName(factoryClassName);
            Object factoryInstance = clazz.newInstance();
            return (T)factoryInstance;
        }
        catch (Exception ex) {
            String factoryName = factoryType.getClass().getSimpleName();
            String msg = "Failed to instantiate the " + factoryName + " implementation: " + factoryClassName;
            throw new StudioRuntimeException(msg, ex);
        }
    }
}

