/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.util;

import com.tandbergtv.watchpoint.studio.util.ValidationUtil;

public class ConvertExprUtility {
    private static String CLOSE_BRACKET = ")";
    private static final char ADD_OPERATOR = '+';
    private static final char MULTIPLY_OPERATOR = '*';

    public static String convertTimerExpression(String expr) {
        String newExpression = null;
        String[] operands = ValidationUtil.getOperands(expr);
        int numberOfOperands = operands.length;
        switch (numberOfOperands) {
            case 1: {
                newExpression = ConvertExprUtility.convertExpression(operands, ' ');
                break;
            }
            case 2: {
                char operator = ValidationUtil.getOperator(expr);
                newExpression = ConvertExprUtility.convertExpression(operands, operator);
                break;
            }
        }
        return newExpression;
    }

    private static String convertExpression(String[] operands, char operator) {
        String newExpression = null;
        newExpression = operator == '+' ? ConvertExprUtility.buildAddExpression(operands) : (operator == '*' ? ConvertExprUtility.buildMlpyExpression(operands) : ConvertExprUtility.buildGeneralExpression(operands));
        return newExpression;
    }

    public static String convertDecisionExpression(String expr) {
        StringBuffer expression = new StringBuffer("#{()}");
        expression.insert(expression.lastIndexOf(CLOSE_BRACKET), expr);
        return expression.toString();
    }

    private static boolean isConstant(String operand) {
        int i = 0;
        while (i < operand.length()) {
            char c = operand.charAt(i);
            if (c > ':' || c < '0') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isDurationConstant(String operand) {
        return operand.contains(":");
    }

    private static String buildAddExpression(String[] operands) {
        int index = 0;
        StringBuffer addExpr = new StringBuffer("util.addDates()");
        String[] stringArray = operands;
        int n = operands.length;
        int n2 = 0;
        while (n2 < n) {
            String operand = stringArray[n2];
            StringBuffer durationVariable = new StringBuffer("executionContext.getVariable().toString()");
            if (ConvertExprUtility.isDurationConstant(operand)) {
                addExpr.insert(addExpr.lastIndexOf(CLOSE_BRACKET), "\"" + operand + "\"");
            } else {
                durationVariable.insert(durationVariable.indexOf(CLOSE_BRACKET), "\"" + operand + "\"");
                addExpr.insert(addExpr.lastIndexOf(CLOSE_BRACKET), durationVariable);
            }
            if (++index == 1) {
                addExpr.insert(addExpr.lastIndexOf(CLOSE_BRACKET), ",");
            }
            ++n2;
        }
        return addExpr.toString();
    }

    private static String buildMlpyExpression(String[] operands) {
        int index = 0;
        StringBuffer mlpyExpr = new StringBuffer("util.multiplyDate()");
        String[] stringArray = operands;
        int n = operands.length;
        int n2 = 0;
        while (n2 < n) {
            String operand = stringArray[n2];
            StringBuffer integerVariable = new StringBuffer("(Double.parseDouble(executionContext.getVariable().toString()))");
            StringBuffer durationVariable = new StringBuffer("executionContext.getVariable().toString()");
            if (ConvertExprUtility.isConstant(operand)) {
                if (ConvertExprUtility.isDurationConstant(operand)) {
                    mlpyExpr.insert(mlpyExpr.lastIndexOf(CLOSE_BRACKET), "\"" + operand + "\"");
                } else {
                    mlpyExpr.insert(mlpyExpr.lastIndexOf(CLOSE_BRACKET), operand);
                }
            } else if (index != 0) {
                integerVariable.insert(integerVariable.indexOf(CLOSE_BRACKET), "\"" + operand + "\"");
                mlpyExpr.insert(mlpyExpr.lastIndexOf(CLOSE_BRACKET), integerVariable);
            } else {
                durationVariable.insert(durationVariable.indexOf(CLOSE_BRACKET), "\"" + operand + "\"");
                mlpyExpr.insert(mlpyExpr.lastIndexOf(CLOSE_BRACKET), durationVariable);
            }
            if (++index == 1) {
                mlpyExpr.insert(mlpyExpr.lastIndexOf(CLOSE_BRACKET), ",");
            }
            ++n2;
        }
        return mlpyExpr.toString();
    }

    private static String buildGeneralExpression(String[] operands) {
        StringBuffer variable = new StringBuffer("executionContext.getVariable()");
        if (ConvertExprUtility.isDurationConstant(operands[0])) {
            return operands[0];
        }
        variable.insert(variable.indexOf(CLOSE_BRACKET), "\"" + operands[0] + "\"");
        return variable.toString();
    }
}

