/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.util;

import com.tandbergtv.watchpoint.studio.ui.model.WPTransition;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.model.ConditionExpression;
import com.tandbergtv.watchpoint.studio.validation.model.ContainerVariable;
import com.tandbergtv.watchpoint.studio.validation.model.DecisionExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbpm.gd.jpdl.model.Condition;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionExprValidationUtil {
    private static final String[] REGULAR_EXPRESSION = new String[]{"[(][\\s]*[)]", "[[a-z][A-Z][0-9]'][\\s]*[=|&][\\s]*[['[A-Z][a-z]][0-9]]", "[|&][\\s]*[')]", "[(][\\s]*[|&]", "[)][\\s]*[(]", "[=][\\s]*[)]", "[)][\\s]*[[a-z][A-Z][0-9]]", "[|][\\s]*[&]", "[&][\\s]*[|]", "[|&][\\s]*[=]", "[=][\\s]*[|&]", "[|][\\s]*[|][\\s]*[|]", "[&][\\s]*[&][\\s]*[&]", "[=][\\s]*[=][\\s]*[=]", "[\\w][\\s]*'[\\s]*[\\w]", "[\\w][\\s]*![\\s]*[\\w]", "[&][!]", "[!][\\s]", "[|][!]", "[!][|]", "[&][!]", "[!][&]", "[&][\\s]+[&]", "[(!][)]"};
    private static final char[] ILLEGAL_CHARACTERS = new char[]{'+', '-', '*', '/', '?'};
    private static final String PREFIX = "(";
    private static final String SUFFIX = ")";
    private static final String SPACE = " ";
    private static final String EMPTY_STRING = "";
    private static final String SINGLE_QUOTE = "'";

    public static ValidationMessage validateDecisonExpr(DecisionExpression decExprObject) {
        ValidationMessage valMsg = null;
        Decision decision = decExprObject.getDecision();
        String expr = decision.getExpression();
        if (expr != null && !EMPTY_STRING.equals(expr)) {
            valMsg = DecisionExprValidationUtil.isDecisionExprValid(expr, decExprObject);
        }
        return valMsg;
    }

    public static ValidationMessage validateConditionExpr(ConditionExpression conditionExprObject) {
        String expr;
        ValidationMessage valMsg = null;
        Transition transition = conditionExprObject.getTransition();
        Condition condition = transition.getCondition();
        String string = expr = condition != null ? condition.getExpression() : null;
        if (expr != null && !EMPTY_STRING.equals(expr)) {
            valMsg = DecisionExprValidationUtil.isConditionExprValid(expr, conditionExprObject);
        }
        return valMsg;
    }

    public static Map<Integer, String> getOperands(String expression) {
        HashMap<Integer, String> operands = new HashMap<Integer, String>();
        char[] specialChars = new char[]{'=', '|', '!', '&', '(', ')', '>', '<', '#', '{', ' ', '?', ':'};
        int startIndex = 0;
        int index = 0;
        String tempValue = EMPTY_STRING;
        while (index < expression.length()) {
            char c = expression.charAt(index);
            boolean isValue = true;
            int j = 0;
            while (j < specialChars.length) {
                if (c == specialChars[j]) {
                    isValue = false;
                    break;
                }
                ++j;
            }
            if (isValue) {
                tempValue = String.valueOf(tempValue) + c;
            }
            if (!tempValue.equals(EMPTY_STRING) && !isValue) {
                if (tempValue.indexOf(39) == -1 && !DecisionExprValidationUtil.isConstant(tempValue)) {
                    operands.put(startIndex, tempValue);
                }
                tempValue = EMPTY_STRING;
            }
            if (!isValue) {
                startIndex = index + 1;
            }
            ++index;
        }
        return operands;
    }

    private static ValidationMessage isConditionExprValid(String expr, ConditionExpression conditionExprObject) {
        ValidationMessage valMsg = null;
        Transition transition = conditionExprObject.getTransition();
        valMsg = DecisionExprValidationUtil.isExpressionValid(expr, conditionExprObject.getContainerVariables(), transition);
        return valMsg;
    }

    private static ValidationMessage isDecisionExprValid(String expr, DecisionExpression decExprObject) {
        Decision decision = decExprObject.getDecision();
        ValidationMessage valMsg = null;
        String[] decisionExpr = expr.split("\\?");
        if (decisionExpr.length != 2) {
            valMsg = new ValidationMessage(decision, ValidationMessageType.Error, ValidationMessageCode.INVALID_DECISION_EXPRESSION);
            return valMsg;
        }
        valMsg = DecisionExprValidationUtil.isExpressionValid(decisionExpr[0], decExprObject.getContainerVariables(), decision);
        if (valMsg != null) {
            return valMsg;
        }
        if (!DecisionExprValidationUtil.isValidTransitionState(decisionExpr[1])) {
            valMsg = new ValidationMessage(decision, ValidationMessageType.Error, ValidationMessageCode.INVALID_NUMBER_OF_VARIABLES);
            return valMsg;
        }
        if (!DecisionExprValidationUtil.isValidTransitionExpression(decisionExpr[1])) {
            valMsg = new ValidationMessage(decision, ValidationMessageType.Error, ValidationMessageCode.INVALID_TRANSITION_QUOTES);
            return valMsg;
        }
        if (!DecisionExprValidationUtil.isValidTransExprQuotes(decisionExpr[1])) {
            valMsg = new ValidationMessage(decision, ValidationMessageType.Error, ValidationMessageCode.INVALID_TRANSITION_EXTRA_QUOTES);
            return valMsg;
        }
        if (!DecisionExprValidationUtil.isTransVariableEmpty(decisionExpr[1])) {
            valMsg = new ValidationMessage(decision, ValidationMessageType.Error, ValidationMessageCode.TRANSITION_VARIABLE_EMPTY);
            return valMsg;
        }
        String invalidNames = DecisionExprValidationUtil.getInvalidTransitionVariables(decisionExpr[1], decExprObject);
        if (invalidNames != null) {
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(invalidNames);
            valMsg = new ValidationMessage(decision, ValidationMessageType.Error, ValidationMessageCode.INVALID_TRANSITION_VARIABLES, parameters);
            return valMsg;
        }
        return valMsg;
    }

    private static ValidationMessage isExpressionValid(String expr, List<ContainerVariable> variables, Object obj) {
        ValidationMessage valMsg = null;
        if (!(expr = expr.trim()).startsWith(PREFIX) || !expr.endsWith(SUFFIX)) {
            valMsg = new ValidationMessage(obj, ValidationMessageType.Error, ValidationMessageCode.INVALID_OPEN_CLOSE_PARENTHESIS);
            return valMsg;
        }
        if (!DecisionExprValidationUtil.checkBrackets(expr)) {
            valMsg = new ValidationMessage(obj, ValidationMessageType.Error, ValidationMessageCode.INVALID_BRACKETS);
            return valMsg;
        }
        if (!DecisionExprValidationUtil.checkQuotes(expr)) {
            valMsg = new ValidationMessage(obj, ValidationMessageType.Error, ValidationMessageCode.INVALID_QUOTES);
            return valMsg;
        }
        if (DecisionExprValidationUtil.checkExpr(expr)) {
            if (obj instanceof Decision) {
                valMsg = new ValidationMessage(obj, ValidationMessageType.Error, ValidationMessageCode.INVALID_DECISION_EXPRESSION);
            } else if (obj instanceof WPTransition) {
                valMsg = new ValidationMessage(obj, ValidationMessageType.Error, ValidationMessageCode.INVALID_CONDITION_EXPRESSION);
            }
            return valMsg;
        }
        if (DecisionExprValidationUtil.checkIllegalCharacters(expr)) {
            valMsg = new ValidationMessage(obj, ValidationMessageType.Error, ValidationMessageCode.ILLEGAL_CHARACTERS);
            return valMsg;
        }
        String invalidNames = DecisionExprValidationUtil.getInvalidVariables(DecisionExprValidationUtil.getLogicalOperands(expr), variables);
        if (invalidNames != null) {
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(invalidNames);
            valMsg = new ValidationMessage(obj, ValidationMessageType.Error, ValidationMessageCode.INVALID_VARIABLES, parameters);
            return valMsg;
        }
        return valMsg;
    }

    private static boolean checkBrackets(String expr) {
        int sLength = expr.length();
        int inBracket = 0;
        int i = 0;
        while (i < sLength) {
            if (expr.charAt(i) == '(' && inBracket >= 0) {
                ++inBracket;
            } else if (expr.charAt(i) == ')') {
                --inBracket;
            }
            ++i;
        }
        return inBracket == 0;
    }

    private static boolean checkQuotes(String expr) {
        int sLength = expr.length();
        int inQuote = 0;
        int i = 0;
        while (i < sLength) {
            if (expr.charAt(i) == '\'') {
                ++inQuote;
            }
            ++i;
        }
        return inQuote % 2 == 0;
    }

    private static boolean checkExpr(String expr) {
        String[] stringArray = REGULAR_EXPRESSION;
        int n = REGULAR_EXPRESSION.length;
        int n2 = 0;
        while (n2 < n) {
            String regExpr = stringArray[n2];
            Pattern pattern = Pattern.compile(regExpr);
            Matcher matcher = pattern.matcher(expr);
            if (matcher.find()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static String[] getLogicalOperands(String expression) {
        char[] operators = new char[]{'=', '|', '!', '&', '(', ')', '>', '<'};
        int index = 0;
        int exprLength = expression.length();
        String tempValue = EMPTY_STRING;
        StringBuffer operandValue = new StringBuffer();
        ArrayList<String> tempOperands = new ArrayList<String>();
        while (index < exprLength) {
            char c = expression.charAt(index);
            boolean isValue = true;
            int j = 0;
            while (j < operators.length) {
                if (c == operators[j]) {
                    isValue = false;
                    break;
                }
                ++j;
            }
            if (isValue) {
                operandValue.append(expression.charAt(index));
                tempValue = operandValue.toString().replaceAll(SPACE, EMPTY_STRING);
            }
            if (!tempValue.equals(EMPTY_STRING) && !isValue || index == exprLength - 1 && isValue) {
                if (tempValue.indexOf(SINGLE_QUOTE) == -1 && !DecisionExprValidationUtil.isConstant(tempValue)) {
                    tempOperands.add(operandValue.toString().trim());
                }
                operandValue.delete(0, operandValue.length());
                tempValue = EMPTY_STRING;
            }
            ++index;
        }
        String[] operands = tempOperands.toArray(new String[tempOperands.size()]);
        return operands;
    }

    private static boolean checkIllegalCharacters(String expr) {
        boolean illegal = false;
        String[] operands = DecisionExprValidationUtil.getLogicalOperands(expr);
        if (operands != null && operands.length > 0) {
            StringBuffer tempString = new StringBuffer();
            String[] stringArray = operands;
            int n = operands.length;
            int n2 = 0;
            while (n2 < n) {
                String operand = stringArray[n2];
                tempString.append(operand.trim());
                ++n2;
            }
            String operandsString = tempString.toString();
            int j = 0;
            while (j < ILLEGAL_CHARACTERS.length) {
                int index = operandsString.indexOf(ILLEGAL_CHARACTERS[j]);
                if (index != -1) {
                    illegal = true;
                    break;
                }
                ++j;
            }
        }
        return illegal;
    }

    private static String getInvalidVariables(String[] exprVariables, List<ContainerVariable> variables) {
        HashSet<String> invalidNames = new HashSet<String>();
        boolean isValidVariable = false;
        String[] stringArray = exprVariables;
        int n = exprVariables.length;
        int n2 = 0;
        while (n2 < n) {
            String exprVariable = stringArray[n2];
            isValidVariable = false;
            for (ContainerVariable variable : variables) {
                if (!exprVariable.trim().equals(variable.getName())) continue;
                isValidVariable = true;
                break;
            }
            if (!isValidVariable) {
                invalidNames.add(exprVariable.trim());
            }
            ++n2;
        }
        return DecisionExprValidationUtil.buildCSVString(invalidNames);
    }

    private static boolean isValidTransitionState(String expr) {
        String[] transitionStates = expr.split(":");
        return transitionStates.length == 2;
    }

    private static String getInvalidTransitionVariables(String expr, DecisionExpression exprObject) {
        String[] transitionStates;
        HashSet<String> invalidNames = new HashSet<String>();
        boolean isValidVariable = false;
        List<Transition> transVariables = DecisionExprValidationUtil.getTransitionVariables(exprObject.getDecision());
        expr = expr.replaceAll(SINGLE_QUOTE, EMPTY_STRING);
        String[] stringArray = transitionStates = expr.split(":");
        int n = transitionStates.length;
        int n2 = 0;
        while (n2 < n) {
            String transitionState = stringArray[n2];
            isValidVariable = false;
            for (Transition variable : transVariables) {
                if (!transitionState.trim().equals(variable.getName())) continue;
                isValidVariable = true;
                break;
            }
            if (!isValidVariable) {
                invalidNames.add(transitionState.trim());
            }
            ++n2;
        }
        return DecisionExprValidationUtil.buildCSVString(invalidNames);
    }

    private static String buildCSVString(Collection<String> values) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (String name : values) {
            buf.append(first ? EMPTY_STRING : ", ");
            first = false;
            buf.append(name);
        }
        return buf.length() == 0 ? null : buf.toString();
    }

    private static List<Transition> getTransitionVariables(Decision decision) {
        Transition[] transitionVariables;
        ArrayList<Transition> variables = new ArrayList<Transition>();
        Transition[] transitionArray = transitionVariables = decision.getTransitions();
        int n = transitionVariables.length;
        int n2 = 0;
        while (n2 < n) {
            Transition variable = transitionArray[n2];
            variables.add(variable);
            ++n2;
        }
        return variables;
    }

    private static int checkQuoteCount(String expr) {
        int sLength = expr.length();
        int inQuote = 0;
        int i = 0;
        while (i < sLength) {
            if (expr.charAt(i) == '\'') {
                ++inQuote;
            }
            ++i;
        }
        return inQuote;
    }

    private static boolean isValidTransitionExpression(String expr) {
        String[] transVariables;
        String[] stringArray = transVariables = expr.split(":");
        int n = transVariables.length;
        int n2 = 0;
        while (n2 < n) {
            String transVariable = stringArray[n2];
            if (!transVariable.trim().startsWith(SINGLE_QUOTE) || !transVariable.trim().endsWith(SINGLE_QUOTE)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isTransVariableEmpty(String expr) {
        String[] transVariables;
        String[] stringArray = transVariables = expr.split(":");
        int n = transVariables.length;
        int n2 = 0;
        while (n2 < n) {
            String transVariable = stringArray[n2];
            if (transVariable.equals("''")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isValidTransExprQuotes(String expr) {
        String[] transVariables;
        String[] stringArray = transVariables = expr.split(":");
        int n = transVariables.length;
        int n2 = 0;
        while (n2 < n) {
            String transVariable = stringArray[n2];
            if (DecisionExprValidationUtil.checkQuoteCount(transVariable) != 2) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isConstant(String operand) {
        int i = 0;
        while (i < operand.length()) {
            char c = operand.charAt(i);
            if (c > '9' || c < '0') {
                return false;
            }
            ++i;
        }
        return true;
    }
}

