/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.util;

import com.tandbergtv.watchpoint.studio.util.TimerExprValidator;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.model.DueDateExpression;

public class DueDateExprValidator
extends TimerExprValidator {
    private DueDateExpression dde;

    public DueDateExprValidator(DueDateExpression dde) {
        super(dde.getContainerVariables());
        this.dde = dde;
    }

    public ValidationMessage validate() {
        return this.validate(this.dde.getDueDateElement().getDueDate());
    }

    protected ValidationMessage getInvalidAdditionExprVM() {
        return this.createValidationMessage(ValidationMessageCode.DUEDATE_OPERANDS_TYPE_DURATION);
    }

    protected ValidationMessage getInvalidMultiplicationExprVM() {
        return this.createValidationMessage(ValidationMessageCode.DUEDATE_OPERAND_TYPE_DURATION_INTEGER);
    }

    protected ValidationMessage getInvalidUnaryExprVM() {
        return this.createValidationMessage(ValidationMessageCode.DUEDATE_INVALID_DURATION_FORMAT);
    }

    protected ValidationMessage getGenericInvalidTimerExprVM() {
        return this.createValidationMessage(ValidationMessageCode.DUEDATE_INVALID_TIMER_EXPRESSION);
    }

    private ValidationMessage createValidationMessage(ValidationMessageCode code) {
        return new ValidationMessage(this.dde.getDueDateElement(), ValidationMessageType.Error, code);
    }
}

