/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.util;

import com.tandbergtv.watchpoint.studio.util.TimerExprValidator;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.model.DurationExpression;

public class DurationExprValidator
extends TimerExprValidator {
    private DurationExpression de;

    public DurationExprValidator(DurationExpression de) {
        super(de.getContainerVariables());
        this.de = de;
    }

    public ValidationMessage validate() {
        return this.validate(this.de.getDurationElement().getDuration());
    }

    protected ValidationMessage getInvalidAdditionExprVM() {
        return this.createValidationMessage(ValidationMessageCode.DURATION_OPERANDS_TYPE_DURATION);
    }

    protected ValidationMessage getInvalidMultiplicationExprVM() {
        return this.createValidationMessage(ValidationMessageCode.DURATION_OPERAND_TYPE_DURATION_INTEGER);
    }

    protected ValidationMessage getInvalidUnaryExprVM() {
        return this.createValidationMessage(ValidationMessageCode.DURATION_INVALID_DURATION_FORMAT);
    }

    protected ValidationMessage getGenericInvalidTimerExprVM() {
        return this.createValidationMessage(ValidationMessageCode.DURATION_INVALID_TIMER_EXPRESSION);
    }

    private ValidationMessage createValidationMessage(ValidationMessageCode code) {
        return new ValidationMessage(this.de.getDurationElement(), ValidationMessageType.Error, code);
    }
}

