/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.apache.log4j.Logger;

public final class FileUtil {
    private static final Logger logger = Logger.getLogger(FileUtil.class);
    private static final long COPY_BUF_MAX_SIZE = 67076096L;

    private FileUtil() {
    }

    public static boolean deleteFolderContents(File folder, boolean deleteSubFolders) {
        if (!folder.isDirectory()) {
            return false;
        }
        File[] contents = folder.listFiles();
        boolean result = true;
        if (contents != null) {
            int i = 0;
            while (i < contents.length) {
                if (contents[i].isDirectory() && deleteSubFolders) {
                    result &= FileUtil.deleteFolderContents(contents[i], deleteSubFolders);
                    result &= contents[i].delete();
                } else {
                    result &= contents[i].delete();
                }
                ++i;
            }
        }
        return result;
    }

    public static boolean copyFileOrFolder(File source, File target, boolean copySubFolders) {
        boolean result;
        block7: {
            block8: {
                result = true;
                if (!source.isDirectory()) break block8;
                if (target.exists() && !target.isDirectory()) {
                    String msg = "The target location is an existing file, failed to copy folder: " + source.getAbsolutePath() + " to: " + target.getAbsolutePath();
                    logger.warn((Object)msg);
                    return false;
                }
                if (!target.exists() && !target.mkdirs()) {
                    String msg = "Failed to create folder: " + target.getAbsolutePath() + " when attempting to copy folder: " + source.getAbsolutePath();
                    logger.warn((Object)msg);
                    return false;
                }
                File[] contents = source.listFiles();
                if (contents == null) break block7;
                File[] fileArray = contents;
                int n = contents.length;
                int n2 = 0;
                while (n2 < n) {
                    File targetContent;
                    File content = fileArray[n2];
                    if (!(content.isDirectory() && !copySubFolders || FileUtil.copyFileOrFolder(content, targetContent = new File(target, content.getName()), copySubFolders))) {
                        result = false;
                        break block7;
                    }
                    ++n2;
                }
                break block7;
            }
            if (target.exists()) {
                String msg = "The target location already exists, failed to copy file: " + source.getAbsolutePath() + " to: " + target.getAbsolutePath();
                logger.warn((Object)msg);
                return false;
            }
            try {
                FileUtil.copyFile(source, target);
            }
            catch (IOException ex) {
                String msg = "Failed when copying file from: " + source.getAbsolutePath() + " to: " + target.getAbsolutePath();
                logger.warn((Object)msg, (Throwable)ex);
                result = false;
            }
        }
        return result;
    }

    private static void copyFile(File source, File target) throws IOException {
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            inStream = new FileInputStream(source);
            outStream = new FileOutputStream(target);
            FileChannel inputChannel = inStream.getChannel();
            FileChannel outputChannel = outStream.getChannel();
            long inputChannelSize = inputChannel.size();
            long marker = 0L;
            while (marker < inputChannelSize) {
                marker += inputChannel.transferTo(marker, 67076096L, outputChannel);
            }
        }
        finally {
            FileUtil.closeStream(inStream, source.getAbsolutePath());
            FileUtil.closeStream(outStream, target.getAbsolutePath());
        }
    }

    private static void closeStream(Closeable stream, String filePath) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException ex) {
            logger.warn((Object)("Failed to close the file stream for file: " + filePath + ", ignoring error."), (Throwable)ex);
        }
    }
}

