/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.util;

import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.sse.core.internal.model.ModelManagerImpl;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.model.SemanticElementFactory;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.common.xml.XmlAdapterFactory;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.Transition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticElementUtil {
    public static final String ADAPTER_KEY = "Adapter";
    public static final String ADAPTER_FACTORY_KEY = "AdapterFactory";
    public static final String SEMANTIC_ELEMENT_KEY = "SemanticElement";
    public static final String TRANSITION_PATH_SEPARATOR = "/";

    public static Map<String, Object> createSemanticElement(String modelKey, String xmlString, String semanticElementId) throws UnsupportedEncodingException, IOException {
        IStructuredModel model = null;
        try {
            IModelManager modelManager = null;
            IDOMModel domModel = null;
            IDOMDocument document = null;
            modelManager = ModelManagerImpl.getInstance();
            ByteArrayInputStream inStream = new ByteArrayInputStream(xmlString.getBytes());
            model = modelManager.getModelForRead(modelKey, (InputStream)inStream, null);
            domModel = (IDOMModel)model;
            document = domModel.getDocument();
            Element rootElement = document.getDocumentElement();
            SemanticElementFactory seFactory = new SemanticElementFactory("org.jbpm.gd.jpdl.editor");
            SemanticElement element = seFactory.createById(semanticElementId);
            XmlAdapterFactory adapterFactory = new XmlAdapterFactory((Document)document, seFactory);
            XmlAdapter adapter = adapterFactory.adapt((Node)rootElement);
            adapter.initialize(element);
            if (element instanceof NodeElementContainer) {
                SemanticElementUtil.setTransitionSources((NodeElementContainer)element);
            }
            HashMap<String, Object> output = new HashMap<String, Object>();
            output.put(ADAPTER_KEY, adapter);
            output.put(ADAPTER_FACTORY_KEY, adapterFactory);
            output.put(SEMANTIC_ELEMENT_KEY, element);
            HashMap<String, Object> hashMap = output;
            return hashMap;
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public static WorkflowTemplate createWorkflowTemplate(String modelKey, String xmlString) throws UnsupportedEncodingException, IOException {
        Map<String, Object> output = SemanticElementUtil.createSemanticElement(modelKey, xmlString, "org.jbpm.gd.jpdl.processDefinition");
        WorkflowTemplate template = (WorkflowTemplate)output.get(SEMANTIC_ELEMENT_KEY);
        return template;
    }

    public static SemanticElement getSemanticElement(Map<String, Object> semanticElementOutputMap) {
        return (SemanticElement)semanticElementOutputMap.get(SEMANTIC_ELEMENT_KEY);
    }

    public static XmlAdapter getAdapter(Map<String, Object> semanticElementOutputMap) {
        return (XmlAdapter)semanticElementOutputMap.get(ADAPTER_KEY);
    }

    public static XmlAdapterFactory getAdapterFactory(Map<String, Object> semanticElementOutputMap) {
        return (XmlAdapterFactory)semanticElementOutputMap.get(ADAPTER_FACTORY_KEY);
    }

    private static void setTransitionSources(NodeElementContainer container) {
        NodeElement[] nodeElementArray = container.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement node = nodeElementArray[n2];
            Transition[] transitionArray = node.getTransitions();
            int n3 = transitionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Transition transition = transitionArray[n4];
                transition.setSource(node);
                ++n4;
            }
            ++n2;
        }
    }
}

