/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.util;

import com.tandbergtv.watchpoint.studio.util.TimerExpression;
import com.tandbergtv.watchpoint.studio.util.TimerExpressionMarshaller;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.model.ContainerVariable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TimerExprValidator {
    private static final String REGEX_SHORT_DURATION = "[0-23][0-23]:\\d\\d:\\d\\d";
    private static final String REGEX_LONG_DURATION = "\\d\\dT[0-23][0-23]:\\d\\d:\\d\\d";
    private List<ContainerVariable> variables;

    protected TimerExprValidator(List<ContainerVariable> variables) {
        this.variables = variables != null ? variables : new ArrayList();
    }

    protected ValidationMessage validate(String expression) {
        if (expression == null || expression.trim().length() == 0) {
            return null;
        }
        return this.validate(TimerExpressionMarshaller.unmarshall(expression));
    }

    protected ValidationMessage validate(TimerExpression te) {
        if (te == null) {
            return null;
        }
        if (te.getOperator() == null) {
            if (te.getOperand2() != null) {
                return this.getGenericInvalidTimerExprVM();
            }
            return this.validateUnaryExpression(te.getOperand1());
        }
        if (te.getOperator().equals("+")) {
            return this.validateAdditionExpression(te.getOperand1(), te.getOperand2());
        }
        if (te.getOperator().equals("*")) {
            return this.validateMultiplicationExpression(te.getOperand1(), te.getOperand2());
        }
        return null;
    }

    protected abstract ValidationMessage getInvalidAdditionExprVM();

    protected abstract ValidationMessage getInvalidMultiplicationExprVM();

    protected abstract ValidationMessage getInvalidUnaryExprVM();

    protected abstract ValidationMessage getGenericInvalidTimerExprVM();

    private ValidationMessage validateAdditionExpression(String operand1, String operand2) {
        if (!this.isValidShortDuration(operand1) || !this.isValidShortDuration(operand2)) {
            return this.getInvalidAdditionExprVM();
        }
        return null;
    }

    private ValidationMessage validateMultiplicationExpression(String operand1, String operand2) {
        if (!this.isValidShortDuration(operand1) || !this.isValidMultiplier(operand2)) {
            return this.getInvalidMultiplicationExprVM();
        }
        return null;
    }

    private ValidationMessage validateUnaryExpression(String operand) {
        if (!this.isValidShortDuration(operand) && !this.isLongDurationConstant(operand)) {
            return this.getInvalidUnaryExprVM();
        }
        return null;
    }

    private boolean isValidShortDuration(String operand) {
        return this.isShortDurationConstant(operand) || this.isVariableOfTypeDuration(operand);
    }

    private boolean isShortDurationConstant(String constant) {
        return Pattern.matches(REGEX_SHORT_DURATION, constant);
    }

    private boolean isVariableOfTypeDuration(String varName) {
        for (ContainerVariable variable : this.variables) {
            if (variable.getName() == null || !variable.getName().equals(varName)) continue;
            return variable.getType() != null && variable.getType().equals("DURATION");
        }
        return false;
    }

    private boolean isValidMultiplier(String operand) {
        return this.isValidMultiplicativeConstant(operand) || this.isVariableOfTypeStringOrInt(operand);
    }

    private boolean isValidMultiplicativeConstant(String constant) {
        try {
            return Double.parseDouble(constant) > 0.0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean isVariableOfTypeStringOrInt(String varName) {
        for (ContainerVariable variable : this.variables) {
            if (variable.getName() == null || !variable.getName().equals(varName)) continue;
            return variable.getType() != null && (variable.getType().equals("STRING") || variable.getType().equals("INT"));
        }
        return false;
    }

    private boolean isLongDurationConstant(String constant) {
        return Pattern.matches(REGEX_LONG_DURATION, constant);
    }
}

