/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.graph;

import com.tandbergtv.watchpoint.studio.validation.graph.IWatchPointGraph;
import com.tandbergtv.watchpoint.studio.validation.graph.WatchPointDecorator;
import com.tandbergtv.watchpoint.studio.validation.graph.WatchPointGraphUtils;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.utils.UserDataContainer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jbpm.gd.jpdl.model.Fork;
import org.jbpm.gd.jpdl.model.Join;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForkPathLabeler {
    public static final String DEFAULT_FORK_NEST_LEVEL_KEY = "fork.NestLevel";
    public static final String DEFAULT_JOIN_VERTICES_KEY = "fork.JoinVertices";
    public static final String DEFAULT_REACHABLE_VERTICES_KEY = "fork.reachableVertices";
    public static final String DEFAULT_FORK_VERTICES_KEY = "join.ForkVertices";
    private String forkNestLevelKey;
    private String joinVerticesKey;
    private String reachableVerticesKey;
    private String forkVerticesKey;
    private WatchPointDecorator<String, Integer> nestLevelDecorator;
    private WatchPointDecorator<String, Set<Vertex>> joinVerticesDecorator;
    private WatchPointDecorator<String, Set<Vertex>> reachableVerticesDecorator;
    private WatchPointDecorator<String, Set<Vertex>> forkVerticesDecorator;
    private Set<Vertex> forkVertices;
    private Set<Vertex> joinVertices;
    private IWatchPointGraph graph;

    public ForkPathLabeler() {
        this(null, null, null, null);
    }

    public ForkPathLabeler(String nestKey, String joinKey, String reachableVertexKey, String forkKey) {
        this.forkNestLevelKey = nestKey != null ? nestKey : DEFAULT_FORK_NEST_LEVEL_KEY;
        this.joinVerticesKey = joinKey != null ? joinKey : DEFAULT_JOIN_VERTICES_KEY;
        this.reachableVerticesKey = reachableVertexKey != null ? reachableVertexKey : DEFAULT_REACHABLE_VERTICES_KEY;
        this.forkVerticesKey = forkKey != null ? forkKey : DEFAULT_FORK_VERTICES_KEY;
        this.nestLevelDecorator = new WatchPointDecorator(this.forkNestLevelKey, UserData.SHARED);
        this.joinVerticesDecorator = new WatchPointDecorator(this.joinVerticesKey, UserData.SHARED);
        this.reachableVerticesDecorator = new WatchPointDecorator(this.reachableVerticesKey, UserData.SHARED);
        this.forkVerticesDecorator = new WatchPointDecorator(this.forkVerticesKey, UserData.SHARED);
    }

    public IWatchPointGraph getGraph() {
        return this.graph;
    }

    public Set<Vertex> getForkVertices() {
        return this.forkVertices;
    }

    public Set<Vertex> getJoinVertices() {
        return this.joinVertices;
    }

    public Set<Vertex> getJoinVertices(Vertex forkVertex) {
        return this.joinVerticesDecorator.getValue((UserDataContainer)forkVertex);
    }

    public Set<Vertex> getReachableVertices(Vertex forkVertex) {
        return this.reachableVerticesDecorator.getValue((UserDataContainer)forkVertex);
    }

    public Set<Vertex> getJoinVertices(Edge forkEdge) {
        return this.joinVerticesDecorator.getValue((UserDataContainer)forkEdge);
    }

    public Set<Vertex> getReachableVertices(Edge forkEdge) {
        return this.reachableVerticesDecorator.getValue((UserDataContainer)forkEdge);
    }

    public Set<Vertex> getForkVertices(Vertex joinVertex) {
        return this.forkVerticesDecorator.getValue((UserDataContainer)joinVertex);
    }

    public int getForkNestLevel(Vertex forkVertex) {
        return this.nestLevelDecorator.getValue((UserDataContainer)forkVertex);
    }

    public void labelForkPaths(IWatchPointGraph graph) {
        this.initialize(graph);
        for (Vertex forkVertex : this.forkVertices) {
            Set<Vertex> reachableVertices = this.reachableVerticesDecorator.getValue((UserDataContainer)forkVertex);
            Set<Vertex> pairedJoinVertices = this.joinVerticesDecorator.getValue((UserDataContainer)forkVertex);
            Set edges = forkVertex.getOutEdges();
            for (Object edgeObject : edges) {
                Edge forkEdge = (Edge)edgeObject;
                this.labelForkTransition(forkVertex, forkEdge);
                reachableVertices.addAll((Collection<Vertex>)this.reachableVerticesDecorator.getValue((UserDataContainer)forkEdge));
                pairedJoinVertices.addAll((Collection<Vertex>)this.joinVerticesDecorator.getValue((UserDataContainer)forkEdge));
            }
            for (Vertex joinVertex : pairedJoinVertices) {
                this.forkVerticesDecorator.getValue((UserDataContainer)joinVertex).add(forkVertex);
            }
        }
    }

    protected void initialize(IWatchPointGraph graph) {
        this.graph = graph;
        this.forkVertices = new HashSet<Vertex>();
        this.joinVertices = new HashSet<Vertex>();
        for (Object vertexObject : graph.getVertices()) {
            Vertex vertex = (Vertex)vertexObject;
            Object element = WatchPointGraphUtils.getElement((UserDataContainer)vertex);
            if (element instanceof Fork) {
                this.forkVertices.add(vertex);
                this.nestLevelDecorator.setValue(1, (UserDataContainer)vertex);
                this.joinVerticesDecorator.setValue(new HashSet(), (UserDataContainer)vertex);
                this.reachableVerticesDecorator.setValue(new HashSet(), (UserDataContainer)vertex);
                Set edges = vertex.getOutEdges();
                for (Object edgeElement : edges) {
                    Edge edge = (Edge)edgeElement;
                    this.joinVerticesDecorator.setValue(new HashSet(), (UserDataContainer)edge);
                    this.reachableVerticesDecorator.setValue(new HashSet(), (UserDataContainer)edge);
                }
                continue;
            }
            if (!(element instanceof Join)) continue;
            this.joinVertices.add(vertex);
            this.forkVerticesDecorator.setValue(new HashSet(), (UserDataContainer)vertex);
        }
    }

    protected void labelForkTransition(Vertex forkVertex, Edge forkEdge) {
        Vertex firstVertex = forkEdge.getOpposite(forkVertex);
        VertexVisitorState state = new VertexVisitorState(forkVertex, forkEdge);
        this.visitVertex(firstVertex, state);
        this.joinVerticesDecorator.setValue(state.joinVertices, (UserDataContainer)forkEdge);
        this.reachableVerticesDecorator.setValue(state.reachableVertices, (UserDataContainer)forkEdge);
    }

    private void visitVertex(Vertex vertex, VertexVisitorState state) {
        if (state.reachableVertices.contains(vertex)) {
            return;
        }
        if (vertex.equals(state.forkVertex)) {
            return;
        }
        Object element = WatchPointGraphUtils.getElement((UserDataContainer)vertex);
        if (element instanceof Join) {
            if (state.currentNestLevel == state.startNestLevel) {
                state.joinVertices.add(vertex);
                return;
            }
            VertexVisitorState vertexVisitorState = state;
            vertexVisitorState.currentNestLevel = vertexVisitorState.currentNestLevel - 1;
        } else if (element instanceof Fork) {
            VertexVisitorState vertexVisitorState = state;
            vertexVisitorState.currentNestLevel = vertexVisitorState.currentNestLevel + 1;
            int forkNestLevel = this.nestLevelDecorator.getValue((UserDataContainer)vertex);
            if (state.currentNestLevel > forkNestLevel) {
                this.nestLevelDecorator.setValue(state.currentNestLevel, (UserDataContainer)vertex);
            }
        }
        state.reachableVertices.add(vertex);
        int currentNestLevel = state.currentNestLevel;
        for (Object vertexObject : vertex.getSuccessors()) {
            Vertex successor = (Vertex)vertexObject;
            this.visitVertex(successor, state);
            state.currentNestLevel = currentNestLevel;
        }
    }

    private class VertexVisitorState {
        private Set<Vertex> joinVertices;
        private Set<Vertex> reachableVertices;
        private Vertex forkVertex;
        private int currentNestLevel;
        private int startNestLevel;

        VertexVisitorState(Vertex forkVertex, Edge forkEdge) {
            this.forkVertex = forkVertex;
            this.joinVertices = (Set)ForkPathLabeler.this.joinVerticesDecorator.getValue((UserDataContainer)forkEdge);
            this.reachableVertices = (Set)ForkPathLabeler.this.reachableVerticesDecorator.getValue((UserDataContainer)forkEdge);
            this.currentNestLevel = this.startNestLevel = ((Integer)ForkPathLabeler.this.nestLevelDecorator.getValue((UserDataContainer)forkVertex)).intValue();
        }
    }
}

