/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.graph;

import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.validation.graph.IWatchPointGraph;
import com.tandbergtv.watchpoint.studio.validation.graph.NodeDefinitionGraph;
import com.tandbergtv.watchpoint.studio.validation.graph.WorkflowTemplateGraph;
import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.SimpleDirectedSparseVertex;
import edu.uci.ics.jung.utils.GraphUtils;
import edu.uci.ics.jung.utils.UserData;
import java.util.HashSet;
import java.util.Set;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphFactory {
    protected GraphFactory() {
    }

    public static GraphFactory createFactory() {
        return new GraphFactory();
    }

    public IWatchPointGraph createGraph(Object objectToGraph) {
        DirectedSparseGraph graph = null;
        if (objectToGraph instanceof WorkflowTemplate) {
            graph = new WorkflowTemplateGraph();
            this.buildGraph((NodeElementContainer)((WorkflowTemplate)objectToGraph), (IWatchPointGraph)graph);
        } else if (objectToGraph instanceof NodeDefinition) {
            graph = new NodeDefinitionGraph();
            this.buildGraph((NodeDefinition)objectToGraph, (IWatchPointGraph)graph);
        } else {
            String objDesc = objectToGraph == null ? "a null object." : "an object of type: " + objectToGraph.getClass().getName() + ".";
            throw new IllegalArgumentException("Cannot build a graph for " + objDesc);
        }
        return graph;
    }

    public <T extends IWatchPointGraph> T createReverseGraph(T graph) {
        IWatchPointGraph graphCopy = (IWatchPointGraph)graph.copy();
        Set edges = graphCopy.getEdges();
        HashSet<DirectedEdge> reversedEdges = new HashSet<DirectedEdge>();
        for (DirectedEdge edge : edges) {
            reversedEdges.add(this.createEdge(edge.getDest(), edge.getSource(), null));
        }
        GraphUtils.removeEdges((Graph)graphCopy, (Set)edges);
        GraphUtils.addEdges((Graph)graphCopy, reversedEdges);
        return (T)graphCopy;
    }

    private void buildGraph(NodeElementContainer nodeContainer, IWatchPointGraph graph) {
        NodeElement[] nodes = nodeContainer.getNodeElements();
        int nodeCount = nodes != null ? nodes.length : 0;
        graph.addUserDatum("element", nodeContainer, UserData.SHARED);
        Vertex[] vertices = new Vertex[nodeCount];
        int i = 0;
        while (i < nodeCount) {
            vertices[i] = this.createVertex(nodes[i]);
            graph.addVertex(vertices[i]);
            ++i;
        }
        i = 0;
        while (i < nodeCount) {
            Transition[] transitions = nodes[i].getTransitions();
            int transitionCount = transitions != null ? transitions.length : 0;
            int t = 0;
            while (t < transitionCount) {
                Transition transition = transitions[t];
                String nodeName = transition.getTo();
                Vertex destination = this.findVertex(graph, nodeName);
                if (!destination.isSuccessorOf(vertices[i])) {
                    graph.addEdge((Edge)this.createEdge(vertices[i], destination, transition));
                }
                ++t;
            }
            ++i;
        }
    }

    private Vertex createVertex(Object element) {
        SimpleDirectedSparseVertex vertex = new SimpleDirectedSparseVertex();
        vertex.addUserDatum((Object)"element", element, UserData.SHARED);
        return vertex;
    }

    private DirectedEdge createEdge(Vertex source, Vertex destination, Object edgeElement) {
        DirectedSparseEdge edge = new DirectedSparseEdge(source, destination);
        if (edgeElement != null) {
            edge.addUserDatum((Object)"element", edgeElement, UserData.SHARED);
        }
        return edge;
    }

    private Vertex findVertex(IWatchPointGraph graph, String name) {
        Vertex result = null;
        for (Vertex vertex : graph.getVertices()) {
            String vertexElementName;
            NodeElement node = (NodeElement)vertex.getUserDatum((Object)"element");
            String string = vertexElementName = node != null ? node.getName() : null;
            if (vertexElementName == null || !vertexElementName.equals(name)) continue;
            result = vertex;
            break;
        }
        return result;
    }
}

