/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.impl;

import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.IValidator;
import com.tandbergtv.watchpoint.studio.validation.ValidatorFactory;
import com.tandbergtv.watchpoint.studio.validation.impl.RuleValidator;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationRuleConfiguratonException;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationRuleReader;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidatorUndefinedException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValidatorFactory
extends ValidatorFactory {
    private static final Logger logger = Logger.getLogger(DefaultValidatorFactory.class);
    private static final Map<Class<?>, List<IValidationRule<?>>> VALIDATION_RULE_MAP = new HashMap();
    private static boolean MAP_INITIALIZED = false;

    public DefaultValidatorFactory() {
        DefaultValidatorFactory.initializeValidationRuleMap();
    }

    @Override
    public <T> IValidator<T> createValidator(Class<T> targetClass) {
        RuleValidator validator = new RuleValidator();
        if (!VALIDATION_RULE_MAP.containsKey(targetClass)) {
            String msg = "Class: " + targetClass.getName() + " is not specified in validation rule configuration," + " cannot create validator.";
            throw new ValidatorUndefinedException(msg);
        }
        List rules = VALIDATION_RULE_MAP.get(targetClass);
        validator.setRules(rules);
        return validator;
    }

    @Override
    public <T> IValidator<T> createValidator(T target) {
        Class<?> targetClass = target.getClass();
        return this.createValidator((T)targetClass);
    }

    private static synchronized void initializeValidationRuleMap() {
        if (MAP_INITIALIZED) {
            return;
        }
        try {
            VALIDATION_RULE_MAP.putAll(ValidationRuleReader.readValidationRules());
        }
        catch (ValidationRuleConfiguratonException vrce) {
            Map<Class<?>, List<IValidationRule<?>>> parsedRules = vrce.getValidationRules();
            if (parsedRules != null) {
                VALIDATION_RULE_MAP.putAll(parsedRules);
            }
            logger.error((Object)"Failed to load validation rule configuration.", (Throwable)vrce);
        }
        MAP_INITIALIZED = true;
    }
}

