/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.impl;

import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationRuleConfiguratonException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidationRuleReader {
    private static final String RESOURCE_NAME = "/validation-rules.properties";
    private static final Logger logger = Logger.getLogger(ValidationRuleReader.class);

    private ValidationRuleReader() {
    }

    public static Map<Class<?>, List<IValidationRule<?>>> readValidationRules() throws ValidationRuleConfiguratonException {
        HashMap ruleMap = new HashMap();
        boolean invalidConfiguration = false;
        InputStream inStream = null;
        try {
            try {
                Properties properties = new Properties();
                inStream = ValidationRuleReader.class.getResourceAsStream(RESOURCE_NAME);
                properties.load(inStream);
                for (Object key : properties.keySet()) {
                    String entityClassName = (String)key;
                    String value = properties.getProperty(entityClassName);
                    try {
                        String[] ruleClassNames = value.split(",");
                        int ruleClassCount = ruleClassNames != null ? ruleClassNames.length : 0;
                        Class<?> entityClass = Class.forName(entityClassName);
                        ArrayList<IValidationRule> rules = new ArrayList<IValidationRule>();
                        int i = 0;
                        while (i < ruleClassCount) {
                            String name;
                            String string = name = ruleClassNames[i] != null ? ruleClassNames[i].trim() : "";
                            if (name.length() > 0) {
                                Class<?> ruleClass = Class.forName(name);
                                IValidationRule rule = (IValidationRule)ruleClass.newInstance();
                                rules.add(rule);
                            }
                            ++i;
                        }
                        ruleMap.put(entityClass, rules);
                    }
                    catch (Exception ex) {
                        invalidConfiguration = true;
                        String msg = "Failed to read and load the validation rules for entity: " + entityClassName;
                        logger.error((Object)msg, (Throwable)ex);
                    }
                }
            }
            catch (Exception ex) {
                String msg = "Failed to load the configuration of the Validation Rules.";
                throw new ValidationRuleConfiguratonException(msg, ruleMap, ex);
            }
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException ioe) {
                logger.warn((Object)"Failure when closing the stream.", (Throwable)ioe);
            }
        }
        if (invalidConfiguration) {
            String msg = "Failed to load some of the configuration of the Validation Rules.";
            throw new ValidationRuleConfiguratonException(msg, ruleMap);
        }
        return ruleMap;
    }
}

