/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.impl;

import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.ui.actionconfig.ActionClassConfiguration;
import com.tandbergtv.watchpoint.studio.ui.actionconfig.ActionConfigurationManager;
import com.tandbergtv.watchpoint.studio.ui.actionconfig.ActionVariableConfiguration;
import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.IDueDateElement;
import com.tandbergtv.watchpoint.studio.ui.model.IDurationElement;
import com.tandbergtv.watchpoint.studio.ui.model.ManualTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.util.SemanticElementUtil;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.IValidationService;
import com.tandbergtv.watchpoint.studio.validation.IValidator;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.ValidationRuleInstantiationException;
import com.tandbergtv.watchpoint.studio.validation.ValidationServiceException;
import com.tandbergtv.watchpoint.studio.validation.ValidatorFactory;
import com.tandbergtv.watchpoint.studio.validation.graph.GraphFactory;
import com.tandbergtv.watchpoint.studio.validation.graph.IWatchPointGraph;
import com.tandbergtv.watchpoint.studio.validation.model.ActionVariable;
import com.tandbergtv.watchpoint.studio.validation.model.ConditionExpression;
import com.tandbergtv.watchpoint.studio.validation.model.ContainerNode;
import com.tandbergtv.watchpoint.studio.validation.model.ContainerVariable;
import com.tandbergtv.watchpoint.studio.validation.model.DecisionExpression;
import com.tandbergtv.watchpoint.studio.validation.model.DueDateExpression;
import com.tandbergtv.watchpoint.studio.validation.model.DurationExpression;
import com.tandbergtv.watchpoint.studio.validation.model.NodeDefinitionInstance;
import com.tandbergtv.watchpoint.studio.validation.model.SuperStateNodeDefinitionInstance;
import com.tandbergtv.watchpoint.studio.validation.model.TemplateNodeDefinitionInstance;
import com.tandbergtv.watchpoint.studio.validation.rules.actionvariable.ActionVariableValueRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.jbpm.gd.common.model.GenericElement;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.Fork;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.StartState;
import org.jbpm.gd.jpdl.model.Task;
import org.jbpm.gd.jpdl.model.Transition;
import org.jbpm.gd.jpdl.model.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationService
implements IValidationService {
    private static final Logger logger = Logger.getLogger(ValidationService.class);
    private static final String MODEL_ID = "ModelForValidation";
    private static final Lock MODEL_LOCK = new ReentrantLock();
    private ValidatorFactory validatorFactory = ValidatorFactory.createFactory();
    private GraphFactory graphFactory = GraphFactory.createFactory();

    @Override
    public List<ValidationMessage> validateTemplate(WorkflowTemplateDTO template) {
        String xml = template.getXml();
        WorkflowTemplate templateSE = this.createWorkflowTemplate(xml);
        return this.validateTemplate(templateSE);
    }

    @Override
    public List<ValidationMessage> validateTemplate(WorkflowTemplate template) {
        ArrayList<ValidationMessage> allMessages = new ArrayList<ValidationMessage>();
        List<ValidationMessage> messages = null;
        messages = this.validatorFactory.createValidator(WorkflowTemplate.class).validate((Class<WorkflowTemplate>)((Object)template));
        this.addMessages(allMessages, messages);
        IWatchPointGraph graph = this.graphFactory.createGraph(template);
        messages = this.validatorFactory.createValidator(graph).validate(graph);
        this.addMessages(allMessages, messages);
        NodeElement[] nodeElements = template.getNodeElements();
        if (nodeElements != null) {
            NodeElement[] nodeElementArray = nodeElements;
            int n = nodeElements.length;
            int n2 = 0;
            while (n2 < n) {
                NodeElement nodeElement = nodeElementArray[n2];
                this.validateTemplateNode(nodeElement, template, allMessages);
                ++n2;
            }
        }
        return allMessages;
    }

    @Override
    public List<ValidationMessage> validateNodeDefinition(NodeDefinition nodeDefinition) {
        ArrayList<ValidationMessage> allMessages = new ArrayList<ValidationMessage>();
        List<ValidationMessage> messages = null;
        messages = this.validatorFactory.createValidator(NodeDefinition.class).validate((Class<NodeDefinition>)((Object)nodeDefinition));
        this.addMessages(allMessages, messages);
        this.validateDueDate(nodeDefinition, nodeDefinition, allMessages);
        this.validateDuration(nodeDefinition, nodeDefinition, allMessages);
        if (nodeDefinition.getNodeType() == NodeDefinitionType.SuperState) {
            IWatchPointGraph graph = this.graphFactory.createGraph(nodeDefinition);
            messages = this.validatorFactory.createValidator(graph).validate(graph);
            this.addMessages(allMessages, messages);
            NodeElement[] nodeElements = nodeDefinition.getNodeElements();
            if (nodeElements != null) {
                NodeElement[] nodeElementArray = nodeElements;
                int n = nodeElements.length;
                int n2 = 0;
                while (n2 < n) {
                    NodeElement nodeElement = nodeElementArray[n2];
                    this.validateSuperStateNode(nodeElement, nodeDefinition, allMessages);
                    ++n2;
                }
            }
        } else {
            nodeDefinition.getNodeType();
        }
        return allMessages;
    }

    @Override
    public List<ValidationMessage> validateResourceType(ResourceType resourceType) {
        ArrayList<ValidationMessage> allMessages = new ArrayList<ValidationMessage>();
        List<ValidationMessage> messages = null;
        messages = this.validatorFactory.createValidator(ResourceType.class).validate((Class<ResourceType>)((Object)resourceType));
        this.addMessages(allMessages, messages);
        Set<Message> resourceTypeMessages = resourceType.getMessages();
        if (resourceTypeMessages != null) {
            for (Message message : resourceTypeMessages) {
                messages = this.validateMessage(message);
                this.addMessages(allMessages, messages);
            }
        }
        return allMessages;
    }

    @Override
    public List<ValidationMessage> validateMessage(Message message) {
        IValidator<Class<Message>> validator = this.validatorFactory.createValidator(Message.class);
        return validator.validate((Class<Message>)((Object)message));
    }

    @Override
    public List<ValidationMessage> validateResourceGroup(ResourceGroup group) {
        return this.validatorFactory.createValidator(ResourceGroup.class).validate((Class<ResourceGroup>)((Object)group));
    }

    @Override
    public List<ValidationMessage> validateDecisionExpression(Decision decision, WorkflowTemplate template) {
        List<ContainerVariable> variables = this.getContainerVariables(template);
        DecisionExpression expression = new DecisionExpression(template, variables, decision);
        return this.validatorFactory.createValidator(expression).validate(expression);
    }

    @Override
    public List<ValidationMessage> validateDecisionExpression(Decision decision, NodeDefinition nodeDefinition) {
        List<ContainerVariable> variables = this.getContainerVariables(nodeDefinition);
        DecisionExpression expression = new DecisionExpression(nodeDefinition, variables, decision);
        return this.validatorFactory.createValidator(expression).validate(expression);
    }

    private void validateDecisionExpression(Decision decision, NodeElementContainer container, List<ValidationMessage> allMessages) {
        List<ValidationMessage> messages = null;
        if (container instanceof WorkflowTemplate) {
            WorkflowTemplate template = (WorkflowTemplate)container;
            messages = this.validateDecisionExpression(decision, template);
        } else if (container instanceof NodeDefinition) {
            NodeDefinition nodeDefinition = (NodeDefinition)container;
            messages = this.validateDecisionExpression(decision, nodeDefinition);
        }
        this.addMessages(allMessages, messages);
    }

    @Override
    public List<ValidationMessage> validateCondition(NodeElement node, Transition transition, WorkflowTemplate template) {
        List<ContainerVariable> variables = this.getContainerVariables(template);
        ConditionExpression expression = new ConditionExpression(template, variables, node, transition);
        return this.validatorFactory.createValidator(expression).validate(expression);
    }

    @Override
    public List<ValidationMessage> validateCondition(NodeElement node, Transition transition, NodeDefinition nodeDefinition) {
        List<ContainerVariable> variables = this.getContainerVariables(nodeDefinition);
        ConditionExpression expression = new ConditionExpression(nodeDefinition, variables, node, transition);
        return this.validatorFactory.createValidator(expression).validate(expression);
    }

    private void validateCondition(NodeElement node, Transition transition, NodeElementContainer container, List<ValidationMessage> allMessages) {
        List<ValidationMessage> messages = null;
        if (container instanceof WorkflowTemplate) {
            WorkflowTemplate template = (WorkflowTemplate)container;
            messages = this.validateCondition(node, transition, template);
        } else if (container instanceof NodeDefinition) {
            NodeDefinition nodeDefinition = (NodeDefinition)container;
            messages = this.validateCondition(node, transition, nodeDefinition);
        }
        this.addMessages(allMessages, messages);
    }

    @Override
    public List<ValidationMessage> validateDueDate(IDueDateElement node, WorkflowTemplate template) {
        List<ContainerVariable> variables = this.getContainerVariables(template);
        DueDateExpression expression = new DueDateExpression(template, variables, node);
        return this.validatorFactory.createValidator(expression).validate(expression);
    }

    @Override
    public List<ValidationMessage> validateDueDate(IDueDateElement node, NodeDefinition nodeDefinition) {
        DueDateExpression expression = new DueDateExpression(nodeDefinition, null, node);
        return this.validatorFactory.createValidator(expression).validate(expression);
    }

    private void validateDueDate(IDueDateElement node, NodeElementContainer container, List<ValidationMessage> allMessages) {
        List<ValidationMessage> messages = null;
        if (container instanceof WorkflowTemplate) {
            WorkflowTemplate template = (WorkflowTemplate)container;
            messages = this.validateDueDate(node, template);
        } else if (container instanceof NodeDefinition) {
            NodeDefinition nodeDefinition = (NodeDefinition)container;
            messages = this.validateDueDate(node, nodeDefinition);
        }
        this.addMessages(allMessages, messages);
    }

    @Override
    public List<ValidationMessage> validateDuration(IDurationElement node, WorkflowTemplate template) {
        List<ContainerVariable> variables = this.getContainerVariables(template);
        DurationExpression expression = new DurationExpression(template, variables, node);
        return this.validatorFactory.createValidator(expression).validate(expression);
    }

    @Override
    public List<ValidationMessage> validateDuration(IDurationElement node, NodeDefinition nodeDefinition) {
        DurationExpression expression = new DurationExpression(nodeDefinition, null, node);
        return this.validatorFactory.createValidator(expression).validate(expression);
    }

    private void validateDuration(IDurationElement node, NodeElementContainer container, List<ValidationMessage> allMessages) {
        List<ValidationMessage> messages = null;
        if (container instanceof WorkflowTemplate) {
            WorkflowTemplate template = (WorkflowTemplate)container;
            messages = this.validateDuration(node, template);
        } else if (container instanceof NodeDefinition) {
            NodeDefinition nodeDefinition = (NodeDefinition)container;
            messages = this.validateDuration(node, nodeDefinition);
        }
        this.addMessages(allMessages, messages);
    }

    @Override
    public List<ValidationMessage> validateActionVariableName(GenericElement element) {
        ActionVariable variable = new ActionVariable(element);
        return this.validatorFactory.createValidator(variable).validate(variable);
    }

    @Override
    public List<ValidationMessage> validateActionVariableValue(AutomaticTaskNode node, GenericElement element) {
        List<ActionVariableConfiguration> variables;
        String className = node != null && node.getAction() != null ? node.getAction().getClassName() : null;
        String variableName = element.getName();
        ActionConfigurationManager manager = ActionConfigurationManager.getInstance();
        ActionClassConfiguration actionClass = manager.getActionClass(className);
        ActionVariableConfiguration variableConfiguration = null;
        if (actionClass != null && (variables = actionClass.getVariables()) != null) {
            for (ActionVariableConfiguration currentConfiguration : variables) {
                if (!currentConfiguration.getName().equals(variableName)) continue;
                variableConfiguration = currentConfiguration;
                break;
            }
        }
        ActionVariableValueRule rule = this.createActionVariableRule(variableConfiguration);
        ActionVariable actionVariable = new ActionVariable(node, element, variableConfiguration);
        return rule.validateRule(actionVariable);
    }

    private ActionVariableValueRule createActionVariableRule(ActionVariableConfiguration variable) {
        String ruleClassName;
        ActionVariableValueRule valueRule = null;
        String string = ruleClassName = variable != null ? variable.getValidationRuleClassName() : null;
        if (ruleClassName != null && ruleClassName.trim().length() > 0) {
            try {
                IValidationRule<?> rule = this.validatorFactory.createValidationRule(ruleClassName);
                if (rule instanceof ActionVariableValueRule) {
                    valueRule = (ActionVariableValueRule)rule;
                } else {
                    String msg = "The Rule: " + ruleClassName + " does not extend class: " + ActionVariableValueRule.class.getName() + ", cannot use specified rule for Action Variable validation" + ", using default implementation.";
                    logger.warn((Object)msg);
                }
            }
            catch (ValidationRuleInstantiationException ex) {
                String msg = "Failed to validate ActionVariableValueRule: " + ruleClassName + ", using default implementation.";
                logger.warn((Object)msg, (Throwable)ex);
            }
        }
        if (valueRule == null) {
            valueRule = new ActionVariableValueRule();
        }
        return valueRule;
    }

    private void validateTemplateNode(NodeElement nodeElement, WorkflowTemplate template, List<ValidationMessage> allMessages) {
        List<ValidationMessage> messages = null;
        messages = this.validatorFactory.createValidator(NodeElement.class).validate((Class<NodeElement>)nodeElement);
        this.addMessages(allMessages, messages);
        if (nodeElement instanceof StartState) {
            StartState startState = (StartState)nodeElement;
            messages = this.validatorFactory.createValidator(StartState.class).validate((Class<StartState>)startState);
            this.addMessages(allMessages, messages);
        } else if (nodeElement instanceof Decision) {
            this.validateDecision((Decision)nodeElement, (NodeElementContainer)template, allMessages);
        } else if (nodeElement instanceof AutomaticTaskNode) {
            AutomaticTaskNode automaticTaskNode = (AutomaticTaskNode)nodeElement;
            this.validateAutomaticTaskNode(automaticTaskNode, (NodeElementContainer)template, allMessages);
        } else if (nodeElement instanceof ManualTaskNode) {
            this.validateManualTaskNode((ManualTaskNode)nodeElement, (NodeElementContainer)template, allMessages);
        } else if (nodeElement instanceof NodeDefinition) {
            NodeDefinition node = (NodeDefinition)nodeElement;
            TemplateNodeDefinitionInstance nodeWrapper = new TemplateNodeDefinitionInstance(node, template);
            this.validateNodeDefinitionInstance(nodeWrapper, allMessages);
        } else if (nodeElement instanceof Fork) {
            Fork fork = (Fork)nodeElement;
            messages = this.validatorFactory.createValidator(Fork.class).validate((Class<Fork>)fork);
            this.addMessages(allMessages, messages);
        }
    }

    private void validateSuperStateNode(NodeElement nodeElement, NodeDefinition nodeDefinition, List<ValidationMessage> allMessages) {
        List<ValidationMessage> messages = null;
        messages = this.validatorFactory.createValidator(NodeElement.class).validate((Class<NodeElement>)nodeElement);
        this.addMessages(allMessages, messages);
        if (nodeElement instanceof Decision) {
            this.validateDecision((Decision)nodeElement, nodeDefinition, allMessages);
        } else if (nodeElement instanceof AutomaticTaskNode) {
            AutomaticTaskNode automaticTaskNode = (AutomaticTaskNode)nodeElement;
            this.validateAutomaticTaskNode(automaticTaskNode, nodeDefinition, allMessages);
        } else if (nodeElement instanceof NodeDefinition) {
            NodeDefinition node = (NodeDefinition)nodeElement;
            SuperStateNodeDefinitionInstance nodeWrapper = new SuperStateNodeDefinitionInstance(node, nodeDefinition);
            this.validateNodeDefinitionInstance(nodeWrapper, allMessages);
        }
    }

    private void validateDecision(Decision decision, NodeElementContainer container, List<ValidationMessage> allMessages) {
        List<ValidationMessage> messages = null;
        messages = this.validatorFactory.createValidator(Decision.class).validate((Class<Decision>)decision);
        this.addMessages(allMessages, messages);
        this.validateDecisionExpression(decision, container, allMessages);
        Transition[] transitions = decision.getTransitions();
        if (transitions != null) {
            Transition[] transitionArray = transitions;
            int n = transitions.length;
            int n2 = 0;
            while (n2 < n) {
                Transition transition = transitionArray[n2];
                this.validateCondition((NodeElement)decision, transition, container, allMessages);
                ++n2;
            }
        }
    }

    private void validateAutomaticTaskNode(AutomaticTaskNode node, NodeElementContainer container, List<ValidationMessage> allMessages) {
        GenericElement[] elements;
        List<ValidationMessage> messages = null;
        messages = this.validatorFactory.createValidator(AutomaticTaskNode.class).validate((Class<AutomaticTaskNode>)((Object)node));
        this.addMessages(allMessages, messages);
        Action action = node.getAction();
        GenericElement[] genericElementArray = elements = action != null ? action.getGenericElements() : null;
        if (elements != null) {
            GenericElement[] genericElementArray2 = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                GenericElement element = genericElementArray2[n2];
                messages = this.validateActionVariableValue(node, element);
                this.addMessages(allMessages, messages);
                ++n2;
            }
        }
    }

    private void validateManualTaskNode(ManualTaskNode node, NodeElementContainer container, List<ValidationMessage> allMessages) {
        List<ValidationMessage> messages = null;
        messages = this.validatorFactory.createValidator(ManualTaskNode.class).validate((Class<ManualTaskNode>)((Object)node));
        this.addMessages(allMessages, messages);
        this.validateDueDate(node, container, allMessages);
        ContainerNode containerNode = this.createContainerNode(container, (NodeElement)node);
        messages = this.validatorFactory.createValidator(containerNode).validate(containerNode);
        this.addMessages(allMessages, messages);
    }

    private void validateNodeDefinitionInstance(NodeDefinitionInstance node, List<ValidationMessage> allMessages) {
        List<ValidationMessage> messages = null;
        NodeDefinition nodeDefinition = node.getNodeInstance();
        String definitionName = nodeDefinition.getDefinitionName();
        if (definitionName == null || definitionName.trim().length() == 0) {
            ValidationMessageCode code = ValidationMessageCode.NODE_NODE_DEFINITION_TYPE_UNDEFINED;
            allMessages.add(new ValidationMessage(nodeDefinition, ValidationMessageType.Error, code));
            return;
        }
        IValidator<Class<?>> validator = this.validatorFactory.createValidator(node.getClass());
        messages = validator.validate((Class<?>)((Object)nodeDefinition));
        this.addMessages(allMessages, messages);
        Object container = node.getContainer();
        this.validateDueDate(nodeDefinition, (NodeElementContainer)container, allMessages);
        this.validateDuration(nodeDefinition, (NodeElementContainer)container, allMessages);
        ContainerNode containerNode = this.createContainerNode((NodeElementContainer)node.getContainer(), (NodeElement)nodeDefinition);
        messages = this.validatorFactory.createValidator(containerNode).validate(containerNode);
        this.addMessages(allMessages, messages);
    }

    private List<ContainerVariable> getContainerVariables(WorkflowTemplate template) {
        Variable[] startStateVariables;
        Task task;
        ArrayList<ContainerVariable> variables = new ArrayList<ContainerVariable>();
        StartState startState = template.getStartState();
        Task task2 = task = startState != null ? startState.getTask() : null;
        if (task != null && task.getController() != null && (startStateVariables = task.getController().getVariables()) != null) {
            Variable[] variableArray = startStateVariables;
            int n = startStateVariables.length;
            int n2 = 0;
            while (n2 < n) {
                Variable variable = variableArray[n2];
                variables.add(new ContainerVariable(variable));
                ++n2;
            }
        }
        return variables;
    }

    private List<ContainerVariable> getContainerVariables(NodeDefinition nodeDefinition) {
        List<WPVariable> nodeDefinitionVariables;
        ArrayList<ContainerVariable> variables = new ArrayList<ContainerVariable>();
        if (nodeDefinition.getNodeType() == NodeDefinitionType.SuperState && (nodeDefinitionVariables = nodeDefinition.getVariables()) != null) {
            for (Variable variable : nodeDefinitionVariables) {
                variables.add(new ContainerVariable(variable, false));
            }
        }
        return variables;
    }

    private void addMessages(List<ValidationMessage> allMessages, List<ValidationMessage> messages) {
        if (messages != null) {
            allMessages.addAll(messages);
        }
    }

    private WorkflowTemplate createWorkflowTemplate(String xml) {
        MODEL_LOCK.lock();
        try {
            WorkflowTemplate workflowTemplate = SemanticElementUtil.createWorkflowTemplate(MODEL_ID, xml);
            return workflowTemplate;
        }
        catch (Exception ex) {
            String msg = "Failed to construct Semantic Element: WorkflowTemplate from the XML String.";
            throw new ValidationServiceException(msg, ex);
        }
        finally {
            MODEL_LOCK.unlock();
        }
    }

    private ContainerNode createContainerNode(NodeElementContainer container, NodeElement node) {
        ContainerNode containerNode = null;
        if (container instanceof WorkflowTemplate) {
            WorkflowTemplate template = (WorkflowTemplate)container;
            List<ContainerVariable> variables = this.getContainerVariables(template);
            containerNode = new ContainerNode(template, variables, node);
        } else if (container instanceof NodeDefinition) {
            NodeDefinition nodeDefinition = (NodeDefinition)container;
            List<ContainerVariable> variables = this.getContainerVariables(nodeDefinition);
            containerNode = new ContainerNode(nodeDefinition, variables, node);
        }
        return containerNode;
    }
}

