/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.actionvariable;

import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.model.ActionVariable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionVariableNameRule
implements IValidationRule<ActionVariable> {
    private static final String VALID_TAG_NAME_REGEX = "[a-zA-Z]\\p{Alnum}*";

    @Override
    public List<ValidationMessage> validateRule(ActionVariable target) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        this.validateBlankName(target, messages);
        this.validateNameValue(target, messages);
        return messages;
    }

    private void validateBlankName(ActionVariable target, List<ValidationMessage> messages) {
        if (this.isBlank(target.getElement().getName())) {
            ValidationMessageCode code = ValidationMessageCode.ACTION_VARIABLE_NAME_BLANK;
            messages.add(new ValidationMessage(target.getElement(), ValidationMessageType.Error, code));
        }
    }

    private void validateNameValue(ActionVariable target, List<ValidationMessage> messages) {
        if (this.isBlank(target.getElement().getName())) {
            return;
        }
        if (!Pattern.matches(VALID_TAG_NAME_REGEX, target.getElement().getName())) {
            ValidationMessageCode code = ValidationMessageCode.ACTION_VARIABLE_NAME_INVALID;
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(target.getElement().getName());
            messages.add(new ValidationMessage(target.getElement(), ValidationMessageType.Error, code, parameters));
        }
    }

    private boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }
}

