/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.actionvariable;

import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.model.ActionVariable;
import com.tandbergtv.watchpoint.studio.validation.rules.actionvariable.ActionVariableValueRule;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PositiveIntegerValueRule
extends ActionVariableValueRule {
    @Override
    protected void validateVariableValue(ActionVariable target, List<ValidationMessage> messages) {
        String value = target.getElement().getValue();
        if (value == null) {
            value = "";
        }
        try {
            int intValue = Integer.parseInt(value);
            if (intValue <= 0) {
                ValidationMessageCode code = ValidationMessageCode.ACTION_VARIABLE_VALUE_NOT_POSITIVE_INTEGER;
                ArrayList<String> parameters = new ArrayList<String>();
                parameters.add(target.getElement().getName());
                messages.add(new ValidationMessage(target.getNode(), ValidationMessageType.Error, code, parameters));
            }
        }
        catch (NumberFormatException numberFormatException) {
            ValidationMessageCode code = ValidationMessageCode.ACTION_VARIABLE_VALUE_NOT_POSITIVE_INTEGER;
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(target.getElement().getName());
            messages.add(new ValidationMessage(target.getNode(), ValidationMessageType.Error, code, parameters));
        }
    }
}

