/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.message;

import com.tandbergtv.watchpoint.studio.application.ApplicationProperties;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagePropertiesRule
implements IValidationRule<Message> {
    private static final String MESSAGE_UID_REGEX = "^(\\p{Alnum}{6})((\\.(\\p{Alnum}{1,3}))?)$";

    @Override
    public List<ValidationMessage> validateRule(Message message) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        this.validateParentResourceType(message, messages);
        this.validateMessageName(message, messages);
        this.validateMessageUID(message, messages);
        this.validateMessageProtocol(message, messages);
        this.validateMessageDescription(message, messages);
        return messages;
    }

    private void validateParentResourceType(Message message, List<ValidationMessage> messages) {
        ResourceType resourceType = message.getResourceType();
        if (resourceType == null) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_MESSAGE_RESOURCE_TYPE_NULL;
            messages.add(new ValidationMessage(message, ValidationMessageType.Error, code));
        }
    }

    private void validateMessageName(Message message, List<ValidationMessage> messages) {
        String name = message.getName();
        if (name == null || name.trim().length() == 0) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_MESSAGE_NAME_BLANK;
            messages.add(new ValidationMessage(message, ValidationMessageType.Error, code));
        } else if (name.length() > 50) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_MESSAGE_NAME_TOO_LONG;
            messages.add(new ValidationMessage(message, ValidationMessageType.Error, code));
        }
    }

    private void validateMessageUID(Message message, List<ValidationMessage> messages) {
        if (message.isUIDGenerationRequired() || message.getResourceType() == null) {
            return;
        }
        ResourceType resourceType = message.getResourceType();
        String uid = message.getUid();
        if (uid == null || uid.trim().length() == 0) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_MESSAGE_UID_BLANK;
            messages.add(new ValidationMessage(message, ValidationMessageType.Error, code));
        } else if (!Pattern.matches(MESSAGE_UID_REGEX, uid)) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_MESSAGE_UID_INVALID;
            messages.add(new ValidationMessage(message, ValidationMessageType.Error, code));
        } else {
            ValidationMessageCode code;
            ApplicationProperties properties = ApplicationProperties.getInstance();
            String sourceId = uid.substring(0, 2);
            String destinationId = uid.substring(2, 4);
            String systemId = resourceType.getSystemId();
            String wfsSystemId = properties.getProperty("WFS.ResourceType.SystemId");
            if (message.isIncoming() && !sourceId.equals(systemId)) {
                code = ValidationMessageCode.INCOMING_MESSAGE_UID_SOURCE_INVALID;
                messages.add(new ValidationMessage(message, ValidationMessageType.Error, code));
            }
            if (message.isIncoming() && !destinationId.equals(wfsSystemId)) {
                code = ValidationMessageCode.INCOMING_MESSAGE_UID_DESTINATION_INVALID;
                messages.add(new ValidationMessage(message, ValidationMessageType.Error, code));
            }
            if (!message.isIncoming() && !sourceId.equals(wfsSystemId)) {
                code = ValidationMessageCode.OUTGOING_MESSAGE_UID_SOURCE_INVALID;
                messages.add(new ValidationMessage(message, ValidationMessageType.Error, code));
            }
            if (!message.isIncoming() && !destinationId.equals(systemId)) {
                code = ValidationMessageCode.OUTGOING_MESSAGE_UID_DESTINATION_INVALID;
                messages.add(new ValidationMessage(message, ValidationMessageType.Error, code));
            }
        }
    }

    private void validateMessageProtocol(Message message, List<ValidationMessage> messages) {
        String protocol = message.getProtocol();
        if (protocol != null && protocol.length() > 256) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_MESSAGE_PROTOCOL_TOO_LONG;
            messages.add(new ValidationMessage(message, ValidationMessageType.Error, code));
        }
    }

    private void validateMessageDescription(Message message, List<ValidationMessage> messages) {
        String description = message.getDescription();
        if (description != null && description.length() > 256) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_MESSAGE_DESCRIPTION_TOO_LONG;
            messages.add(new ValidationMessage(message, ValidationMessageType.Error, code));
        }
    }
}

