/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodedefinition;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesRule;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.gd.jpdl.model.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperStateVariablesRule
extends NodeVariablesRule<NodeDefinition> {
    @Override
    protected List<Variable> getVariables(NodeDefinition node) {
        List<WPVariable> nodeVariables;
        ArrayList<Variable> variables = new ArrayList<Variable>();
        if (node.getNodeType() == NodeDefinitionType.SuperState && (nodeVariables = node.getVariables()) != null) {
            variables.addAll(nodeVariables);
        }
        return variables;
    }

    @Override
    protected boolean isValidatingBlankNames(NodeDefinition node) {
        return false;
    }

    @Override
    protected boolean isValidatingNameBlank(NodeDefinition node) {
        return false;
    }

    @Override
    protected boolean isValidatingNameValue(NodeDefinition node) {
        return false;
    }

    @Override
    protected boolean isValidatingMappedNameBlank(NodeDefinition node) {
        return false;
    }

    @Override
    protected ValidationMessageCode getBlankMappedNamesCode(NodeDefinition node) {
        return ValidationMessageCode.SUPERSTATE_VARIABLES_BLANK_MAPPED_NAMES;
    }

    @Override
    protected ValidationMessageCode getMappedNameInvalidCode(NodeDefinition node) {
        return ValidationMessageCode.VARIABLE_MAPPED_NAME_INVALID_IN_SUPERSTATE;
    }

    @Override
    protected ValidationMessageCode getTypeBlankCode(NodeDefinition node) {
        return ValidationMessageCode.VARIABLE_TYPE_BLANK_IN_SUPERSTATE;
    }

    @Override
    protected ValidationMessageCode getTypeInvalidCode(NodeDefinition node) {
        return ValidationMessageCode.VARIABLE_TYPE_INVALID_IN_SUPERSTATE;
    }

    @Override
    protected void validateVariables(NodeDefinition node, List<Variable> variables, List<ValidationMessage> messages) {
        super.validateVariables(node, variables, messages);
        this.validateNamesNotConfigured(node, variables, messages);
    }

    private void validateNamesNotConfigured(NodeDefinition node, List<Variable> variables, List<ValidationMessage> messages) {
        if (variables != null) {
            boolean hasValues = false;
            for (Variable variable : variables) {
                String name = variable.getName();
                if (name == null || name.trim().length() <= 0) continue;
                hasValues = true;
                break;
            }
            if (hasValues) {
                ValidationMessageCode code = ValidationMessageCode.SUPERSTATE_VARIABLES_NAME_DEFINED;
                messages.add(new ValidationMessage(node, ValidationMessageType.Error, code));
            }
        }
    }
}

