/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodedefinition.graph;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPEndState;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.graph.NodeDefinitionGraph;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelementcontainer.graph.AllowedNodeTypesRule;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.NodeElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllowedNodeDefinitionNodeTypesRule
extends AllowedNodeTypesRule<NodeDefinitionGraph> {
    @Override
    protected List<Class<? extends NodeElement>> getAllowedNodeTypes() {
        ArrayList<Class<? extends NodeElement>> allowedTypes = new ArrayList<Class<? extends NodeElement>>();
        allowedTypes.add(WPEndState.class);
        allowedTypes.add(Decision.class);
        allowedTypes.add(NodeDefinition.class);
        allowedTypes.add(AutomaticTaskNode.class);
        return allowedTypes;
    }

    @Override
    protected void validateNodeType(NodeElement node, List<ValidationMessage> messages) {
        super.validateNodeType(node, messages);
        if (node instanceof NodeDefinition && ((NodeDefinition)node).getNodeType() != NodeDefinitionType.SingleNode) {
            ValidationMessageCode code = ValidationMessageCode.INVALID_NODE_TYPE;
            messages.add(new ValidationMessage(node, ValidationMessageType.Error, code));
        }
    }
}

