/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodedefinition.graph;

import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.graph.NodeDefinitionGraph;
import com.tandbergtv.watchpoint.studio.validation.graph.WatchPointGraphUtils;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelementcontainer.graph.NodeReachableRule;
import edu.uci.ics.jung.graph.Vertex;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jbpm.gd.jpdl.model.EndState;
import org.jbpm.gd.jpdl.model.NodeElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDefinitionNodeReachableRule
extends NodeReachableRule<NodeDefinitionGraph> {
    @Override
    protected Set<Vertex> getRootVertices(NodeDefinitionGraph graph) {
        HashSet<Vertex> startVertices = new HashSet<Vertex>();
        for (Object vertexObject : graph.getVertices()) {
            Vertex vertex = (Vertex)vertexObject;
            if (vertex.inDegree() != 0) continue;
            startVertices.add(vertex);
        }
        return startVertices;
    }

    @Override
    protected Set<Vertex> getSinkVertices(NodeDefinitionGraph graph) {
        HashSet<Vertex> endVertices = new HashSet<Vertex>();
        for (Object vertexObject : graph.getVertices()) {
            Vertex vertex = (Vertex)vertexObject;
            NodeElement node = WatchPointGraphUtils.getWTVertexElement(vertex);
            if (!(node instanceof EndState)) continue;
            endVertices.add(vertex);
        }
        return endVertices;
    }

    @Override
    protected void validateNodesUnreachableFromRoot(Set<Vertex> vertices, List<ValidationMessage> messages) {
        this.validateUnreachableNode(vertices, messages, true);
    }

    @Override
    protected void validateNodesUnreachableToSink(Set<Vertex> vertices, List<ValidationMessage> messages) {
        this.validateUnreachableNode(vertices, messages, false);
    }

    private void validateUnreachableNode(Set<Vertex> vertices, List<ValidationMessage> messages, boolean fromStart) {
        if (vertices == null) {
            return;
        }
        for (Vertex vertex : vertices) {
            NodeElement node = WatchPointGraphUtils.getWTVertexElement(vertex);
            ValidationMessageCode code = fromStart ? ValidationMessageCode.NODE_UNREACHABLE_FROM_START : ValidationMessageCode.NODE_UNREACHABLE_TO_END;
            messages.add(new ValidationMessage(node, ValidationMessageType.Error, code));
        }
    }
}

