/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodedefinition.graph;

import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.graph.NodeDefinitionGraph;
import com.tandbergtv.watchpoint.studio.validation.graph.WatchPointGraphUtils;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.UserDataContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jbpm.gd.jpdl.model.EndState;
import org.jbpm.gd.jpdl.model.NodeElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredNodeDefinitionNodesRule
implements IValidationRule<NodeDefinitionGraph> {
    @Override
    public List<ValidationMessage> validateRule(NodeDefinitionGraph graph) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        int endNodeCount = 0;
        boolean otherNodesExist = false;
        Set vertices = graph.getVertices();
        for (Vertex vertex : vertices) {
            NodeElement node = WatchPointGraphUtils.getWTVertexElement(vertex);
            if (node instanceof EndState) {
                ++endNodeCount;
                continue;
            }
            otherNodesExist = true;
        }
        Object graphElement = WatchPointGraphUtils.getElement((UserDataContainer)graph);
        this.validateEndNodeCount(endNodeCount, messages, graphElement);
        this.validateNodeCount(otherNodesExist, messages, graphElement);
        return messages;
    }

    private void validateEndNodeCount(int count, List<ValidationMessage> messages, Object element) {
        if (count == 0) {
            ValidationMessageCode messageCode = ValidationMessageCode.NODEDEFINITION_MISSING_END_NODE;
            messages.add(new ValidationMessage(element, ValidationMessageType.Error, messageCode));
        }
    }

    private void validateNodeCount(boolean nodeExists, List<ValidationMessage> messages, Object element) {
        if (!nodeExists) {
            ValidationMessageCode messageCode = ValidationMessageCode.NODEDEFINITION_MISSING_NODE;
            messages.add(new ValidationMessage(element, ValidationMessageType.Error, messageCode));
        }
    }
}

