/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodedefinition.graph;

import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.graph.NodeDefinitionGraph;
import com.tandbergtv.watchpoint.studio.validation.graph.WatchPointGraphUtils;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.UserDataContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredRootNodeRule
implements IValidationRule<NodeDefinitionGraph> {
    @Override
    public List<ValidationMessage> validateRule(NodeDefinitionGraph graph) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        int rootNodeCount = 0;
        Set vertices = graph.getVertices();
        for (Vertex vertex : vertices) {
            if (vertex.inDegree() != 0) continue;
            ++rootNodeCount;
        }
        Object graphElement = WatchPointGraphUtils.getElement((UserDataContainer)graph);
        this.validateRootNodeCount(rootNodeCount, messages, graphElement);
        return messages;
    }

    private void validateRootNodeCount(int count, List<ValidationMessage> messages, Object element) {
        if (count == 0) {
            ValidationMessageCode messageCode = ValidationMessageCode.NODEDEFINITION_MISSING_ROOT_NODE;
            messages.add(new ValidationMessage(element, ValidationMessageType.Error, messageCode));
        } else if (count > 1) {
            ValidationMessageCode messageCode = ValidationMessageCode.NODEDEFINITION_EXTRA_ROOT_NODE;
            messages.add(new ValidationMessage(element, ValidationMessageType.Error, messageCode));
        }
    }
}

