/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement;

import com.tandbergtv.watchpoint.studio.ui.model.IDurationElement;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DurationRequiredRule
implements IValidationRule<IDurationElement> {
    @Override
    public List<ValidationMessage> validateRule(IDurationElement target) {
        ValidationMessageCode code;
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (this.isNullOrBlank(target.getDuration())) {
            code = ValidationMessageCode.NODE_DURATION_UNDEFINED;
            messages.add(new ValidationMessage(target, ValidationMessageType.Error, code));
        }
        if (this.isNullOrBlank(target.getTaskDuration())) {
            code = ValidationMessageCode.NODE_TASKDURATION_UNDEFINED;
            messages.add(new ValidationMessage(target, ValidationMessageType.Error, code));
        }
        return messages;
    }

    private boolean isNullOrBlank(String value) {
        return value == null || value.trim().length() == 0;
    }
}

