/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement;

import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTransitionNamesRule
implements IValidationRule<NodeElement> {
    @Override
    public List<ValidationMessage> validateRule(NodeElement nodeElement) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        Transition[] transitions = nodeElement.getTransitions();
        if (transitions != null) {
            HashSet<String> names = new HashSet<String>();
            HashSet<String> duplicateNames = new HashSet<String>();
            boolean missingName = false;
            Transition[] transitionArray = transitions;
            int n = transitions.length;
            int n2 = 0;
            while (n2 < n) {
                Transition transition = transitionArray[n2];
                String name = transition.getName();
                boolean isNameBlank = name == null || name.trim().length() == 0;
                missingName |= isNameBlank;
                if (!isNameBlank) {
                    if (names.contains(name = name.trim())) {
                        duplicateNames.add(name);
                    } else {
                        names.add(name);
                    }
                }
                ++n2;
            }
            this.validateBlankNames(nodeElement, missingName, validationMessages);
            this.validateDuplicateNames(nodeElement, duplicateNames, validationMessages);
        }
        return validationMessages;
    }

    private void validateBlankNames(NodeElement node, boolean missing, List<ValidationMessage> messages) {
        if (missing) {
            ValidationMessageCode code = ValidationMessageCode.NODE_TRANSITIONS_NO_LABEL;
            messages.add(new ValidationMessage(node, ValidationMessageType.Error, code));
        }
    }

    private void validateDuplicateNames(NodeElement node, Set<String> duplicates, List<ValidationMessage> messages) {
        for (String name : duplicates) {
            ValidationMessageCode code = ValidationMessageCode.NODE_TRANSITIONS_DUPLICATE_LABEL;
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(name);
            messages.add(new ValidationMessage(node, ValidationMessageType.Error, code, parameters));
        }
    }
}

