/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement;

import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTransitionsParallelRule
implements IValidationRule<NodeElement> {
    @Override
    public List<ValidationMessage> validateRule(NodeElement nodeElement) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        HashMap<String, Integer> targets = new HashMap<String, Integer>();
        Transition[] transitions = nodeElement.getTransitions();
        if (transitions != null) {
            Transition[] transitionArray = transitions;
            int n = transitions.length;
            int n2 = 0;
            while (n2 < n) {
                Transition transition = transitionArray[n2];
                String target = transition.getTo();
                Integer value = (Integer)targets.get(target);
                int count = value != null ? value + 1 : 1;
                targets.put(target, count);
                ++n2;
            }
        }
        this.validateParallelTransitions(nodeElement, targets, messages);
        return messages;
    }

    private void validateParallelTransitions(NodeElement nodeElement, Map<String, Integer> targets, List<ValidationMessage> messages) {
        ValidationMessageCode code = ValidationMessageCode.NODE_TRANSITIONS_PARALLEL;
        for (String target : targets.keySet()) {
            Integer count = targets.get(target);
            if (count <= 1) continue;
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(target);
            parameters.add(count.toString());
            messages.add(new ValidationMessage(nodeElement, ValidationMessageType.Error, code, parameters));
        }
    }
}

