/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.model.ContainerNode;
import com.tandbergtv.watchpoint.studio.validation.model.ContainerVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeVariablesMappingRule
implements IValidationRule<ContainerNode> {
    @Override
    public List<ValidationMessage> validateRule(ContainerNode target) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        List<ContainerVariable> containerVariables = target.getContainerVariables();
        List<Variable> nodeVariables = this.getVariables(target.getNode());
        HashMap<Variable, ContainerVariable> variableMapping = new HashMap<Variable, ContainerVariable>();
        if (nodeVariables != null) {
            for (Variable variable : nodeVariables) {
                String name = variable.getName();
                ContainerVariable match = this.findContainerVariable(name, containerVariables);
                variableMapping.put(variable, match);
            }
        }
        this.validateMissingMapping(target, variableMapping, messages);
        this.validateInvalidMapping(target, variableMapping, messages);
        this.validateMappingTypes(target, variableMapping, messages);
        return messages;
    }

    protected abstract List<Variable> getVariables(NodeElement var1);

    protected void validateMissingMapping(ContainerNode node, Map<Variable, ContainerVariable> mapping, List<ValidationMessage> messages) {
        NodeElement target = node.getNode();
        for (Variable variable : mapping.keySet()) {
            String name = variable.getName();
            if (!this.isBlank(name)) continue;
            ValidationMessageCode code = this.getMappingMissingCode(node);
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(variable.getMappedName());
            messages.add(new ValidationMessage(target, ValidationMessageType.Error, code, parameters));
        }
    }

    protected void validateInvalidMapping(ContainerNode node, Map<Variable, ContainerVariable> mapping, List<ValidationMessage> messages) {
        NodeElement target = node.getNode();
        for (Variable variable : mapping.keySet()) {
            String name = variable.getName();
            if (this.isBlank(name) || mapping.get(variable) != null) continue;
            ValidationMessageCode code = this.getMappingInvalidCode(node);
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(variable.getMappedName());
            parameters.add(variable.getName());
            messages.add(new ValidationMessage(target, ValidationMessageType.Error, code, parameters));
        }
    }

    protected void validateMappingTypes(ContainerNode node, Map<Variable, ContainerVariable> mapping, List<ValidationMessage> messages) {
        NodeElement target = node.getNode();
        for (Variable variable : mapping.keySet()) {
            String mappedType;
            ContainerVariable mappedVariable = mapping.get(variable);
            String type = variable instanceof WPVariable ? ((WPVariable)variable).getType() : null;
            String string = mappedType = mappedVariable != null ? mappedVariable.getType() : null;
            if (this.isBlank(type) || this.isBlank(mappedType) || type.equals(mappedType)) continue;
            ValidationMessageCode code = this.getMappingTypeMismatchCode(node);
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(variable.getMappedName());
            parameters.add(type);
            parameters.add(mappedType);
            messages.add(new ValidationMessage(target, ValidationMessageType.Error, code, parameters));
        }
    }

    protected ValidationMessageCode getMappingMissingCode(ContainerNode node) {
        ValidationMessageCode code = null;
        if (node.isTemplateContainer()) {
            code = ValidationMessageCode.NODE_VARIABLE_NOT_MAPPED_IN_TEMPLATE;
        } else if (node.isNodeDefinitionContainer()) {
            code = ValidationMessageCode.NODE_VARIABLE_NOT_MAPPED_IN_NODE_DEFINITION;
        }
        return code;
    }

    protected ValidationMessageCode getMappingInvalidCode(ContainerNode node) {
        ValidationMessageCode code = null;
        if (node.isTemplateContainer()) {
            code = ValidationMessageCode.NODE_VARIABLE_MAPPING_INVALID_IN_TEMPLATE;
        } else if (node.isNodeDefinitionContainer()) {
            code = ValidationMessageCode.NODE_VARIABLE_MAPPING_INVALID_IN_NODE_DEFINITION;
        }
        return code;
    }

    protected ValidationMessageCode getMappingTypeMismatchCode(ContainerNode node) {
        ValidationMessageCode code = null;
        if (node.isTemplateContainer()) {
            code = ValidationMessageCode.NODE_VARIABLE_TYPE_MISMATCH_IN_TEMPLATE;
        } else if (node.isNodeDefinitionContainer()) {
            code = ValidationMessageCode.NODE_VARIABLE_TYPE_MISMATCH_IN_NODE_DEFINITION;
        }
        return code;
    }

    private boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    private ContainerVariable findContainerVariable(String name, List<ContainerVariable> variables) {
        if (this.isBlank(name) || variables == null) {
            return null;
        }
        for (ContainerVariable variable : variables) {
            if (!name.equals(variable.getName())) continue;
            return variable;
        }
        return null;
    }
}

