/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeVariablesRule<NE extends NodeElement>
implements IValidationRule<NE> {
    private static final String NAME_REGEX = "^.+$";
    private static final String MAPPED_NAME_REGEX = "^.+$";
    private static final String TYPE_REGEX = "^.+$";
    private static final Pattern NAME_PATTERN = Pattern.compile("^.+$");
    private static final Pattern MAPPED_NAME_PATTERN = Pattern.compile("^.+$");
    private static final Pattern TYPE_PATTERN = Pattern.compile("^.+$");

    @Override
    public List<ValidationMessage> validateRule(NE target) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        List<Variable> variables = this.getVariables(target);
        if (variables != null) {
            this.validateVariables(target, variables, messages);
            for (Variable variable : variables) {
                this.validateVariableProperties(target, variable, messages);
            }
        }
        return messages;
    }

    protected abstract List<Variable> getVariables(NE var1);

    protected void validateVariables(NE node, List<Variable> variables, List<ValidationMessage> messages) {
        this.validateBlankNames(node, variables, messages);
        this.validateBlankMappedNames(node, variables, messages);
    }

    protected void validateVariableProperties(NE node, Variable variable, List<ValidationMessage> messages) {
        this.validateNameBlank(node, variable, messages);
        this.validateNameValue(node, variable, messages);
        this.validateMappedNameBlank(node, variable, messages);
        this.validateMappedNameValue(node, variable, messages);
        this.validateTypeBlank(node, variable, messages);
        this.validateTypeValue(node, variable, messages);
    }

    protected void validateBlankNames(NE node, List<Variable> variables, List<ValidationMessage> messages) {
        if (!this.isValidatingBlankNames(node)) {
            return;
        }
        if (variables != null) {
            boolean hasBlanks = false;
            for (Variable variable : variables) {
                String name = variable.getName();
                if (!this.isBlank(name)) continue;
                hasBlanks = true;
                break;
            }
            if (hasBlanks) {
                ValidationMessageCode code = this.getBlankNamesCode(node);
                messages.add(new ValidationMessage(node, ValidationMessageType.Error, code));
            }
        }
    }

    protected void validateBlankMappedNames(NE node, List<Variable> variables, List<ValidationMessage> messages) {
        if (!this.isValidatingBlankMappedNames(node)) {
            return;
        }
        if (variables != null) {
            boolean hasBlanks = false;
            for (Variable variable : variables) {
                String mappedName = variable.getMappedName();
                if (!this.isBlank(mappedName)) continue;
                hasBlanks = true;
                break;
            }
            if (hasBlanks) {
                ValidationMessageCode code = this.getBlankMappedNamesCode(node);
                messages.add(new ValidationMessage(node, ValidationMessageType.Error, code));
            }
        }
    }

    protected void validateNameBlank(NE node, Variable variable, List<ValidationMessage> messages) {
        if (!this.isValidatingNameBlank(node)) {
            return;
        }
        if (this.isBlank(variable.getName())) {
            ValidationMessageCode code = this.getNameBlankCode(node);
            List<String> parameters = this.generateParameters(node, variable);
            messages.add(new ValidationMessage(node, ValidationMessageType.Error, code, parameters));
        }
    }

    protected void validateNameValue(NE node, Variable variable, List<ValidationMessage> messages) {
        if (!this.isValidatingNameValue(node)) {
            return;
        }
        String name = variable.getName();
        if (!this.isBlank(name) && !this.matchesPattern(NAME_PATTERN, name)) {
            ValidationMessageCode code = this.getNameInvalidCode(node);
            List<String> parameters = this.generateParameters(node, variable);
            messages.add(new ValidationMessage(node, ValidationMessageType.Error, code, parameters));
        }
    }

    protected void validateMappedNameBlank(NE node, Variable variable, List<ValidationMessage> messages) {
        if (!this.isValidatingMappedNameBlank(node)) {
            return;
        }
        if (this.isBlank(variable.getMappedName())) {
            ValidationMessageCode code = this.getMappedNameBlankCode(node);
            List<String> parameters = this.generateParameters(node, variable);
            messages.add(new ValidationMessage(node, ValidationMessageType.Error, code, parameters));
        }
    }

    protected void validateMappedNameValue(NE node, Variable variable, List<ValidationMessage> messages) {
        if (!this.isValidatingMappedNameValue(node)) {
            return;
        }
        String mappedName = variable.getMappedName();
        if (!this.isBlank(mappedName) && !this.matchesPattern(MAPPED_NAME_PATTERN, mappedName)) {
            ValidationMessageCode code = this.getMappedNameInvalidCode(node);
            List<String> parameters = this.generateParameters(node, variable);
            messages.add(new ValidationMessage(node, ValidationMessageType.Error, code, parameters));
        }
    }

    protected void validateTypeBlank(NE node, Variable variable, List<ValidationMessage> messages) {
        String type;
        if (!this.isValidatingTypeBlank(node)) {
            return;
        }
        String string = type = variable instanceof WPVariable ? ((WPVariable)variable).getType() : null;
        if (this.isBlank(type)) {
            ValidationMessageCode code = this.getTypeBlankCode(node);
            List<String> parameters = this.generateParameters(node, variable);
            messages.add(new ValidationMessage(node, ValidationMessageType.Error, code, parameters));
        }
    }

    protected void validateTypeValue(NE node, Variable variable, List<ValidationMessage> messages) {
        String type;
        if (!this.isValidatingTypeValue(node)) {
            return;
        }
        String string = type = variable instanceof WPVariable ? ((WPVariable)variable).getType() : null;
        if (!this.isBlank(type) && !this.matchesPattern(TYPE_PATTERN, type)) {
            ValidationMessageCode code = this.getTypeInvalidCode(node);
            List<String> parameters = this.generateParameters(node, variable);
            messages.add(new ValidationMessage(node, ValidationMessageType.Error, code, parameters));
        }
    }

    protected boolean isValidatingBlankNames(NE node) {
        return true;
    }

    protected boolean isValidatingBlankMappedNames(NE node) {
        return true;
    }

    protected boolean isValidatingNameBlank(NE node) {
        return true;
    }

    protected boolean isValidatingNameValue(NE node) {
        return true;
    }

    protected boolean isValidatingMappedNameBlank(NE node) {
        return true;
    }

    protected boolean isValidatingMappedNameValue(NE node) {
        return true;
    }

    protected boolean isValidatingTypeBlank(NE node) {
        return true;
    }

    protected boolean isValidatingTypeValue(NE node) {
        return true;
    }

    protected ValidationMessageCode getBlankNamesCode(NE node) {
        return ValidationMessageCode.NODE_VARIABLES_BLANK_NAMES;
    }

    protected ValidationMessageCode getBlankMappedNamesCode(NE node) {
        return ValidationMessageCode.NODE_VARIABLES_BLANK_MAPPED_NAMES;
    }

    protected ValidationMessageCode getNameBlankCode(NE node) {
        return ValidationMessageCode.VARIABLE_NAME_BLANK;
    }

    protected ValidationMessageCode getNameInvalidCode(NE node) {
        return ValidationMessageCode.VARIABLE_NAME_INVALID;
    }

    protected ValidationMessageCode getMappedNameBlankCode(NE node) {
        return ValidationMessageCode.VARIABLE_MAPPED_NAME_BLANK;
    }

    protected ValidationMessageCode getMappedNameInvalidCode(NE node) {
        return ValidationMessageCode.VARIABLE_MAPPED_NAME_INVALID;
    }

    protected ValidationMessageCode getTypeBlankCode(NE node) {
        return ValidationMessageCode.VARIABLE_TYPE_BLANK;
    }

    protected ValidationMessageCode getTypeInvalidCode(NE node) {
        return ValidationMessageCode.VARIABLE_TYPE_INVALID;
    }

    private boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    private boolean matchesPattern(Pattern pattern, String input) {
        return pattern.matcher(input).matches();
    }

    private List<String> generateParameters(NE node, Variable variable) {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(variable.getName() != null ? variable.getName() : "");
        parameters.add(variable.getMappedName() != null ? variable.getMappedName() : "");
        return parameters;
    }
}

