/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement;

import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeVariablesUniqueRule<NE extends NodeElement>
implements IValidationRule<NE> {
    @Override
    public List<ValidationMessage> validateRule(NE target) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        List<Variable> variables = this.getVariables(target);
        if (variables != null) {
            HashSet<String> names = new HashSet<String>();
            HashSet<String> mappedNames = new HashSet<String>();
            HashSet<String> duplicateNames = new HashSet<String>();
            HashSet<String> duplicateMappedNames = new HashSet<String>();
            for (Variable variable : variables) {
                String mappedName;
                String name = variable.getName();
                if (name != null && name.trim().length() > 0) {
                    if (names.contains(name = name.trim())) {
                        duplicateNames.add(name);
                    } else {
                        names.add(name);
                    }
                }
                if ((mappedName = variable.getMappedName()) == null || mappedName.trim().length() <= 0) continue;
                if (mappedNames.contains(mappedName = mappedName.trim())) {
                    duplicateMappedNames.add(mappedName);
                    continue;
                }
                mappedNames.add(mappedName);
            }
            this.validateDuplicateNames(target, duplicateNames, messages);
            this.validateDuplicateMappedNames(target, duplicateMappedNames, messages);
        }
        return messages;
    }

    protected abstract List<Variable> getVariables(NE var1);

    protected boolean isValidatingUniqueName(NE node) {
        return true;
    }

    protected void validateDuplicateNames(NE target, Set<String> duplicates, List<ValidationMessage> messages) {
        if (!this.isValidatingUniqueName(target)) {
            return;
        }
        for (String name : duplicates) {
            ValidationMessageCode code = this.getDuplicateNameCode(target);
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(name);
            messages.add(new ValidationMessage(target, ValidationMessageType.Error, code, parameters));
        }
    }

    protected ValidationMessageCode getDuplicateNameCode(NE node) {
        return ValidationMessageCode.NODE_VARIABLES_DUPLICATE_NAMES;
    }

    protected boolean isValidatingUniqueMappedName(NE node) {
        return true;
    }

    protected void validateDuplicateMappedNames(NE target, Set<String> duplicates, List<ValidationMessage> messages) {
        if (!this.isValidatingUniqueMappedName(target)) {
            return;
        }
        for (String name : duplicates) {
            ValidationMessageCode code = this.getDuplicateMappedNameCode(target);
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(name);
            messages.add(new ValidationMessage(target, ValidationMessageType.Error, code, parameters));
        }
    }

    protected ValidationMessageCode getDuplicateMappedNameCode(NE node) {
        return ValidationMessageCode.NODE_VARIABLES_DUPLICATE_MAPPED_NAMES;
    }
}

