/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement;

import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.gd.jpdl.model.Condition;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitionsConditionRule
implements IValidationRule<NodeElement> {
    @Override
    public List<ValidationMessage> validateRule(NodeElement target) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        Transition[] transitions = target.getTransitions();
        if (transitions != null) {
            Transition[] transitionArray = transitions;
            int n = transitions.length;
            int n2 = 0;
            while (n2 < n) {
                Transition transition = transitionArray[n2];
                this.validateCondition(target, transition, messages);
                ++n2;
            }
        }
        return messages;
    }

    private void validateCondition(NodeElement target, Transition transition, List<ValidationMessage> messages) {
        Condition condition;
        Condition condition2 = condition = transition != null ? transition.getCondition() : null;
        if (!(target instanceof Decision) && condition != null) {
            ValidationMessageCode code = ValidationMessageCode.TRANSITION_CONDITION_NOT_FROM_DECISION;
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(target.getName());
            messages.add(new ValidationMessage(transition, ValidationMessageType.Error, code, parameters));
        }
    }
}

