/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement;

import com.tandbergtv.watchpoint.studio.ui.model.IWPVariableContainer;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.model.ContainerNode;
import com.tandbergtv.watchpoint.studio.validation.model.ContainerVariable;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesMappingRule;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.nodedefinition.IRequiredVariableFinder;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.nodedefinition.SuperStateRequiredVariableFinder;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.nodedefinition.TemplateRequiredVariableFinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableContainerVariableMappingRule
extends NodeVariablesMappingRule {
    @Override
    protected List<Variable> getVariables(NodeElement node) {
        IWPVariableContainer variableContainer;
        List<WPVariable> nodeVariables;
        ArrayList<Variable> variables = new ArrayList<Variable>();
        if (node instanceof IWPVariableContainer && (nodeVariables = (variableContainer = (IWPVariableContainer)node).getVariables()) != null) {
            variables.addAll(nodeVariables);
        }
        return variables;
    }

    @Override
    protected void validateMissingMapping(ContainerNode node, Map<Variable, ContainerVariable> mapping, List<ValidationMessage> messages) {
        NodeElement containedNode = node.getNode();
        if (containedNode instanceof NodeDefinition) {
            Set<String> names = this.getRequiredVariableNames(node);
            HashMap<Variable, ContainerVariable> filteredMapping = new HashMap<Variable, ContainerVariable>();
            for (Variable variable : mapping.keySet()) {
                if (names == null || !names.contains(variable.getMappedName())) continue;
                filteredMapping.put(variable, mapping.get(variable));
            }
            mapping = filteredMapping;
        }
        super.validateMissingMapping(node, mapping, messages);
    }

    private Set<String> getRequiredVariableNames(ContainerNode node) {
        IRequiredVariableFinder variableFinder = null;
        Set<String> variableNames = null;
        if (node.getContainer() instanceof WorkflowTemplate) {
            variableFinder = new TemplateRequiredVariableFinder();
        } else if (node.getContainer() instanceof NodeDefinition) {
            variableFinder = new SuperStateRequiredVariableFinder();
        }
        if (variableFinder != null) {
            variableNames = variableFinder.getRequiredVariableNames((NodeDefinition)node.getNode());
        }
        return variableNames;
    }
}

