/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.automatictasknode;

import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jbpm.gd.common.model.GenericElement;
import org.jbpm.gd.jpdl.model.Action;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionVariableRule
implements IValidationRule<AutomaticTaskNode> {
    @Override
    public List<ValidationMessage> validateRule(AutomaticTaskNode target) {
        GenericElement[] elements;
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        Action action = target.getAction();
        if (action != null && (elements = action.getGenericElements()) != null) {
            boolean hasBlanks = false;
            HashSet<String> names = new HashSet<String>();
            HashSet<String> duplicates = new HashSet<String>();
            GenericElement[] genericElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                GenericElement element = genericElementArray[n2];
                String name = element.getName();
                if (name != null) {
                    name = name.trim();
                }
                if (name == null || name.length() == 0) {
                    hasBlanks = true;
                } else if (!names.contains(name)) {
                    names.add(name);
                } else {
                    duplicates.add(name);
                }
                ++n2;
            }
            this.validateBlankNames(target, hasBlanks, messages);
            this.validateDuplicateNames(target, duplicates, messages);
        }
        return messages;
    }

    private void validateBlankNames(AutomaticTaskNode node, boolean hasBlanks, List<ValidationMessage> messages) {
        if (hasBlanks) {
            ValidationMessageCode code = ValidationMessageCode.NODE_ACTION_VARIABLES_BLANK_NAMES;
            messages.add(new ValidationMessage(node, ValidationMessageType.Error, code));
        }
    }

    private void validateDuplicateNames(AutomaticTaskNode node, Set<String> duplicates, List<ValidationMessage> messages) {
        for (String name : duplicates) {
            ValidationMessageCode code = ValidationMessageCode.NODE_ACTION_VARIABLES_DUPLICATE_NAMES;
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(name);
            messages.add(new ValidationMessage(node, ValidationMessageType.Error, code, parameters));
        }
    }
}

