/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.decision;

import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.gd.jpdl.model.Condition;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionConfigurationRule
implements IValidationRule<Decision> {
    @Override
    public List<ValidationMessage> validateRule(Decision target) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        boolean nodeConfigured = false;
        boolean transitionConfigured = false;
        String expression = target.getExpression();
        nodeConfigured = expression != null;
        Transition[] transitions = target.getTransitions();
        if (transitions != null) {
            Transition[] transitionArray = transitions;
            int n = transitions.length;
            int n2 = 0;
            while (n2 < n) {
                Transition transition = transitionArray[n2];
                Condition condition = transition.getCondition();
                String string = expression = condition != null ? condition.getExpression() : null;
                if (expression != null) {
                    transitionConfigured = true;
                }
                ++n2;
            }
        }
        this.validateConfiguration(target, nodeConfigured, transitionConfigured, messages);
        if (transitionConfigured && !nodeConfigured) {
            this.validateTransitionConfiguration(target, messages);
        }
        return messages;
    }

    private void validateConfiguration(Decision target, boolean node, boolean transition, List<ValidationMessage> messages) {
        if (node == transition) {
            ValidationMessageCode code = node ? ValidationMessageCode.NODE_DECISION_CONFIGURATION_DUPLICATED : ValidationMessageCode.NODE_DECISION_CONFIGURATION_MISSING;
            messages.add(new ValidationMessage(target, ValidationMessageType.Error, code));
        }
    }

    private void validateTransitionConfiguration(Decision target, List<ValidationMessage> messages) {
        Transition[] transitionArray = target.getTransitions();
        int n = transitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            String expression;
            Transition transition = transitionArray[n2];
            Condition condition = transition.getCondition();
            String string = expression = condition != null ? condition.getExpression() : null;
            if (expression == null || expression.trim().length() == 0) {
                ValidationMessageCode code = ValidationMessageCode.NODE_TRANSITION_CONDITION_MISSING;
                ArrayList<String> parameters = new ArrayList<String>();
                parameters.add(target.getName());
                messages.add(new ValidationMessage(transition, ValidationMessageType.Error, code, parameters));
            }
            ++n2;
        }
    }
}

