/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.nodedefinition;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.IMessageContainer;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.util.DecisionExprValidationUtil;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.nodedefinition.IRequiredVariableFinder;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpm.gd.jpdl.model.Condition;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateRequiredVariableFinder
implements IRequiredVariableFinder {
    @Override
    public Set<String> getRequiredVariableNames(NodeDefinition nodeDefinition) {
        HashSet<String> variableNames = new HashSet<String>();
        if (nodeDefinition.getNodeType() == NodeDefinitionType.SingleNode) {
            this.getRequiredVariableNames(nodeDefinition, variableNames, false);
        } else if (nodeDefinition.getNodeType() == NodeDefinitionType.SuperState) {
            NodeElementContainer superState = (NodeElementContainer)nodeDefinition.getNode();
            if (superState == null) {
                return variableNames;
            }
            NodeElement[] nodeElements = superState.getNodeElements();
            if (nodeElements != null) {
                NodeElement[] nodeElementArray = nodeElements;
                int n = nodeElements.length;
                int n2 = 0;
                while (n2 < n) {
                    NodeElement nodeElement = nodeElementArray[n2];
                    if (nodeElement instanceof NodeDefinition) {
                        NodeDefinition containedDefinition = (NodeDefinition)nodeElement;
                        this.getRequiredVariableNames(containedDefinition, variableNames, true);
                    } else if (nodeElement instanceof Decision) {
                        Decision decision = (Decision)nodeElement;
                        this.getRequiredVariableNames(decision, variableNames);
                    }
                    ++n2;
                }
            }
        }
        return variableNames;
    }

    private void getRequiredVariableNames(NodeDefinition definition, Set<String> variableNames, boolean inSuperState) {
        Map<String, String> compositeKeys;
        IMessageContainer messageContainer = (IMessageContainer)definition.getNode();
        if (messageContainer == null) {
            return;
        }
        List<WPVariable> outgoingVariables = messageContainer.getOutgoingVariables();
        if (outgoingVariables != null) {
            for (WPVariable variable : outgoingVariables) {
                String name;
                String string = name = inSuperState ? variable.getName() : variable.getMappedName();
                if (name == null || name.trim().length() <= 0) continue;
                variableNames.add(name);
            }
        }
        if ((compositeKeys = messageContainer.getCompositeKeys()) != null) {
            Collection names = null;
            names = inSuperState ? compositeKeys.values() : (Collection)compositeKeys.keySet();
            for (String name : names) {
                if (name == null || name.trim().length() <= 0) continue;
                variableNames.add(name);
            }
        }
    }

    private void getRequiredVariableNames(Decision decision, Set<String> variableNames) {
        this.getRequiredVariableNames(decision.getExpression(), variableNames);
        Transition[] transitions = decision.getTransitions();
        if (transitions != null) {
            Transition[] transitionArray = transitions;
            int n = transitions.length;
            int n2 = 0;
            while (n2 < n) {
                Transition transition = transitionArray[n2];
                Condition condition = transition.getCondition();
                String expression = condition != null ? condition.getExpression() : null;
                this.getRequiredVariableNames(expression, variableNames);
                ++n2;
            }
        }
    }

    private void getRequiredVariableNames(String expression, Set<String> variableNames) {
        Map<Integer, String> operands;
        if (expression != null && expression.trim().length() > 0 && (operands = DecisionExprValidationUtil.getOperands(expression)) != null) {
            variableNames.addAll(operands.values());
        }
    }
}

