/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelementcontainer;

import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeNamesUniqueRule<NEC extends NodeElementContainer>
implements IValidationRule<NEC> {
    @Override
    public List<ValidationMessage> validateRule(NEC target) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        HashMap<String, Set<NodeElement>> nameMap = new HashMap<String, Set<NodeElement>>();
        NodeElement[] nodeElementArray = target.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement element = nodeElementArray[n2];
            String name = element.getName();
            if (name != null && name.trim().length() != 0) {
                HashSet<NodeElement> elements = (HashSet<NodeElement>)nameMap.get(name);
                if (elements == null) {
                    elements = new HashSet<NodeElement>();
                    nameMap.put(name, elements);
                }
                elements.add(element);
            }
            ++n2;
        }
        this.validateDuplicateNodeNames(target, nameMap, messages);
        return messages;
    }

    protected void validateDuplicateNodeNames(NEC target, Map<String, Set<NodeElement>> duplicates, List<ValidationMessage> messages) {
        if (duplicates == null) {
            return;
        }
        for (String name : duplicates.keySet()) {
            Set<NodeElement> elements = duplicates.get(name);
            if (elements == null || elements.size() <= 1) continue;
            ValidationMessageCode code = this.getDuplicateNodeNameValidationCode();
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(name);
            messages.add(new ValidationMessage(target, ValidationMessageType.Error, code, parameters));
        }
    }

    protected abstract ValidationMessageCode getDuplicateNodeNameValidationCode();
}

