/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelementcontainer.graph;

import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.graph.IWatchPointGraph;
import com.tandbergtv.watchpoint.studio.validation.graph.WatchPointGraphUtils;
import edu.uci.ics.jung.graph.Vertex;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jbpm.gd.jpdl.model.NodeElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AllowedNodeTypesRule<G extends IWatchPointGraph>
implements IValidationRule<G> {
    @Override
    public List<ValidationMessage> validateRule(G graph) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        Set vertices = graph.getVertices();
        for (Vertex vertex : vertices) {
            this.validateNodeType(WatchPointGraphUtils.getWTVertexElement(vertex), messages);
        }
        return messages;
    }

    protected void validateNodeType(NodeElement node, List<ValidationMessage> messages) {
        Class<?> nodeType = node.getClass();
        List<Class<NodeElement>> allowedNodeTypes = this.getAllowedNodeTypes();
        if (allowedNodeTypes != null && !allowedNodeTypes.contains(nodeType)) {
            ValidationMessageCode code = ValidationMessageCode.INVALID_NODE_TYPE;
            messages.add(new ValidationMessage(node, ValidationMessageType.Error, code));
        }
    }

    protected abstract List<Class<? extends NodeElement>> getAllowedNodeTypes();
}

