/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelementcontainer.graph;

import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.graph.WatchPointGraphUtils;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.EndState;
import org.jbpm.gd.jpdl.model.Fork;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.StartState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphNodeDegreeRule
implements IValidationRule<DirectedSparseGraph> {
    @Override
    public List<ValidationMessage> validateRule(DirectedSparseGraph graph) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        Set vertices = graph.getVertices();
        for (Vertex vertex : vertices) {
            this.validateNodeInDegree(vertex, messages);
            this.validateNodeOutDegree(vertex, messages);
        }
        return messages;
    }

    protected void validateNodeInDegree(Vertex vertex, List<ValidationMessage> messages) {
        NodeElement node = WatchPointGraphUtils.getWTVertexElement(vertex);
        int inDegree = vertex.inDegree();
        if (node instanceof StartState) {
            if (inDegree != 0) {
                ValidationMessageCode code = ValidationMessageCode.INVALID_START_NODE_IN_DEGREE;
                messages.add(new ValidationMessage(node, ValidationMessageType.Error, code));
            }
        } else if (inDegree < 1) {
            ValidationMessageCode code = ValidationMessageCode.INVALID_NODE_IN_DEGREE;
            messages.add(new ValidationMessage(node, ValidationMessageType.Error, code));
        }
    }

    protected void validateNodeOutDegree(Vertex vertex, List<ValidationMessage> messages) {
        NodeElement node = WatchPointGraphUtils.getWTVertexElement(vertex);
        int outDegree = vertex.outDegree();
        if (node instanceof EndState) {
            if (outDegree != 0) {
                ValidationMessageCode code = ValidationMessageCode.INVALID_END_NODE_OUT_DEGREE;
                messages.add(new ValidationMessage(node, ValidationMessageType.Error, code));
            }
        } else if (node instanceof Decision) {
            if (outDegree < 2) {
                ValidationMessageCode code = ValidationMessageCode.INVALID_DECISION_NODE_OUT_DEGREE;
                messages.add(new ValidationMessage(node, ValidationMessageType.Error, code));
            }
        } else if (node instanceof Fork) {
            if (outDegree < 2) {
                ValidationMessageCode code = ValidationMessageCode.INVALID_FORK_NODE_OUT_DEGREE;
                messages.add(new ValidationMessage(node, ValidationMessageType.Error, code));
            }
        } else if (outDegree == 0) {
            ValidationMessageCode code = ValidationMessageCode.NODE_OUT_DEGREE_LOW;
            messages.add(new ValidationMessage(node, ValidationMessageType.Error, code));
        } else if (outDegree > 1) {
            ValidationMessageCode code = ValidationMessageCode.NODE_OUT_DEGREE_HIGH;
            messages.add(new ValidationMessage(node, ValidationMessageType.Error, code));
        }
    }
}

