/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelementcontainer.graph;

import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.graph.GraphFactory;
import com.tandbergtv.watchpoint.studio.validation.graph.IWatchPointGraph;
import edu.uci.ics.jung.algorithms.connectivity.BFSDistanceLabeler;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.GraphUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeReachableRule<G extends IWatchPointGraph>
implements IValidationRule<G> {
    @Override
    public List<ValidationMessage> validateRule(G graph) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        Set<Vertex> rootVertices = this.getRootVertices(graph);
        Set<Vertex> sinkVertices = this.getSinkVertices(graph);
        BFSDistanceLabeler visitor = new BFSDistanceLabeler("distance");
        if (rootVertices != null && rootVertices.size() > 0) {
            IWatchPointGraph graphCopy = (IWatchPointGraph)graph.copy();
            visitor.labelDistances((Graph)graphCopy, rootVertices);
            Set unreachableVertices = visitor.getUnivistedVertices();
            this.validateNodesUnreachableFromRoot(unreachableVertices, messages);
        }
        if (sinkVertices.size() > 0) {
            GraphFactory factory = GraphFactory.createFactory();
            G reversedGraph = factory.createReverseGraph(graph);
            Set vertices = GraphUtils.getEqualVertices(sinkVertices, reversedGraph);
            visitor.labelDistances(reversedGraph, vertices);
            Set unreachableVertices = visitor.getUnivistedVertices();
            this.validateNodesUnreachableToSink(unreachableVertices, messages);
        }
        return messages;
    }

    protected abstract Set<Vertex> getRootVertices(G var1);

    protected abstract Set<Vertex> getSinkVertices(G var1);

    protected abstract void validateNodesUnreachableFromRoot(Set<Vertex> var1, List<ValidationMessage> var2);

    protected abstract void validateNodesUnreachableToSink(Set<Vertex> var1, List<ValidationMessage> var2);
}

