/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.resourcegroup;

import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RGBasicPropertiesRule
implements IValidationRule<ResourceGroup> {
    @Override
    public List<ValidationMessage> validateRule(ResourceGroup target) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        this.validateNotNullAndNotBlank(target, target.getName(), ValidationMessageCode.RESOURCEGROUP_NAME_BLANK, messages);
        this.validateTextMaxLength(target.getName(), 50, target, ValidationMessageCode.RESOURCEGROUP_NAME_TOO_LARGE, messages);
        ResourceType rt = target.getResourceType();
        if (rt == null || rt.getId() == -1L) {
            messages.add(new ValidationMessage(target, ValidationMessageType.Error, ValidationMessageCode.RESOURCEGROUP_RESOURCETYPE_NOTSET));
        }
        this.validateTextMaxLength(target.getFunctionalType(), 256, target, ValidationMessageCode.RESOURCEGROUP_FUNTYPE_TOO_LARGE, messages);
        this.validateTextMaxLength(target.getAllocationStrategyClassName(), 256, target, ValidationMessageCode.RESOURCEGROUP_ALLOCSTRAT_TOO_LARGE, messages);
        this.validateTextMaxLength(target.getImageFileName(), 150, target, ValidationMessageCode.RESOURCEGROUP_IMAGEFILENAME_TOO_LARGE, messages);
        if (target.getProtectionKey() == null) {
            messages.add(new ValidationMessage(target, ValidationMessageType.Error, ValidationMessageCode.RESOURCEGROUP_PROTKEY_BLANK));
        } else if (target.getProtectionKey().getId() == -1L) {
            this.validateNotNullAndNotBlank(target, target.getProtectionKey().getName(), ValidationMessageCode.RESOURCEGROUP_PROTKEY_BLANK, messages);
            this.validateTextMaxLength(target.getProtectionKey().getName(), 50, target, ValidationMessageCode.RESOURCEGROUP_PROTKEY_TOO_LARGE, messages);
        }
        return messages;
    }

    private void validateTextMaxLength(String text, int maxSize, ResourceGroup target, ValidationMessageCode errorCode, List<ValidationMessage> messages) {
        if (text != null && text.length() > maxSize) {
            messages.add(new ValidationMessage(target, ValidationMessageType.Error, errorCode));
        }
    }

    private void validateNotNullAndNotBlank(ResourceGroup target, String property, ValidationMessageCode errorCode, List<ValidationMessage> messages) {
        if (this.isNullOrBlank(property)) {
            messages.add(new ValidationMessage(target, ValidationMessageType.Error, errorCode));
        }
    }

    private boolean isNullOrBlank(String str) {
        return str == null || str.trim().length() == 0;
    }
}

