/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.resourcetype;

import com.tandbergtv.watchpoint.studio.dto.AdaptorType;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptorPropertiesRule
implements IValidationRule<ResourceType> {
    @Override
    public List<ValidationMessage> validateRule(ResourceType target) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        this.validateAdaptorType(target, messages);
        this.validateCustomAdaptorProperties(target, messages);
        this.validateDefaultAdaptorProperties(target, messages);
        return messages;
    }

    private void validateAdaptorType(ResourceType resourceType, List<ValidationMessage> messages) {
        int messageCount;
        AdaptorType adaptorType = resourceType.getAdaptorType();
        Set<Message> rtMessages = resourceType.getMessages();
        int n = messageCount = rtMessages == null ? 0 : rtMessages.size();
        if (adaptorType == null) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_ADAPTOR_TYPE_BLANK;
            messages.add(new ValidationMessage(resourceType, ValidationMessageType.Error, code));
        } else if (adaptorType == AdaptorType.NONE && messageCount > 0) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_ADAPTOR_TYPE_INVALID;
            messages.add(new ValidationMessage(resourceType, ValidationMessageType.Error, code));
        }
    }

    private void validateCustomAdaptorProperties(ResourceType resourceType, List<ValidationMessage> messages) {
        if (resourceType.getAdaptorType() != AdaptorType.CUSTOM) {
            return;
        }
        String className = resourceType.getAdaptorClassName();
        if (className == null || className.trim().length() == 0) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_CUSTOM_ADAPTOR_CLASSNAME_BLANK;
            messages.add(new ValidationMessage(resourceType, ValidationMessageType.Error, code));
        } else if (className.length() > 256) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_CUSTOM_ADAPTOR_CLASSNAME_TOO_LONG;
            messages.add(new ValidationMessage(resourceType, ValidationMessageType.Error, code));
        }
    }

    private void validateDefaultAdaptorProperties(ResourceType resourceType, List<ValidationMessage> messages) {
        if (resourceType.getAdaptorType() != AdaptorType.DEFAULT) {
            return;
        }
        String messageIdentifier = resourceType.getMessageIdentificationClassName();
        if (messageIdentifier != null && messageIdentifier.length() > 256) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_MESSAGE_IDENTIFIER_TOO_LONG;
            messages.add(new ValidationMessage(resourceType, ValidationMessageType.Error, code));
        }
    }
}

