/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.resourcetype;

import com.tandbergtv.watchpoint.studio.dto.ConnectionType;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicPropertiesRule
implements IValidationRule<ResourceType> {
    private static final String SYSTEM_ID_REGEX = "^(\\p{Alnum}{2})$";

    @Override
    public List<ValidationMessage> validateRule(ResourceType target) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        this.validateName(target, messages);
        this.validateSystemId(target, messages);
        this.validateConnectionType(target, messages);
        this.validateDescription(target, messages);
        return messages;
    }

    private void validateName(ResourceType resourceType, List<ValidationMessage> messages) {
        String name = resourceType.getName();
        if (name == null || name.trim().length() == 0) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_NAME_BLANK;
            messages.add(new ValidationMessage(resourceType, ValidationMessageType.Error, code));
        } else if (name.length() > 50) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_NAME_TOO_LONG;
            messages.add(new ValidationMessage(resourceType, ValidationMessageType.Error, code));
        }
    }

    private void validateSystemId(ResourceType resourceType, List<ValidationMessage> messages) {
        String systemId = resourceType.getSystemId();
        if (systemId == null || systemId.trim().length() == 0) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_SYSTEM_ID_BLANK;
            messages.add(new ValidationMessage(resourceType, ValidationMessageType.Error, code));
        } else if (!Pattern.matches(SYSTEM_ID_REGEX, systemId)) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_SYSTEM_ID_INVALID;
            messages.add(new ValidationMessage(resourceType, ValidationMessageType.Error, code));
        }
    }

    private void validateConnectionType(ResourceType resourceType, List<ValidationMessage> messages) {
        ConnectionType connectionType = resourceType.getConnectionType();
        if (connectionType == null) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_CONNECTION_TYPE_BLANK;
            messages.add(new ValidationMessage(resourceType, ValidationMessageType.Error, code));
        }
    }

    private void validateDescription(ResourceType resourceType, List<ValidationMessage> messages) {
        String description = resourceType.getDescription();
        if (description != null && description.length() > 256) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_DESCRIPTION_TOO_LONG;
            messages.add(new ValidationMessage(resourceType, ValidationMessageType.Error, code));
        }
    }
}

