/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.resourcetype;

import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementPropertiesRule
implements IValidationRule<ResourceType> {
    @Override
    public List<ValidationMessage> validateRule(ResourceType target) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        this.validateInitializationProperties(target, messages);
        this.validateHeartbeatProperties(target, messages);
        return messages;
    }

    protected void validateInitializationProperties(ResourceType resourceType, List<ValidationMessage> messages) {
        if (!resourceType.isInitializationRequired()) {
            return;
        }
        String strategyClass = resourceType.getInitializationStrategyClass();
        if (strategyClass == null || strategyClass.trim().length() == 0) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_INITIALIZATION_STRATEGY_BLANK;
            messages.add(new ValidationMessage(resourceType, ValidationMessageType.Error, code));
        } else if (strategyClass.length() > 256) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_INITIALIZATION_STRATEGY_TOO_LONG;
            messages.add(new ValidationMessage(resourceType, ValidationMessageType.Error, code));
        }
    }

    protected void validateHeartbeatProperties(ResourceType resourceType, List<ValidationMessage> messages) {
        String strategyClass;
        if (!resourceType.isHeartbeatRequired()) {
            return;
        }
        if (resourceType.getHeartbeatConnectionType() == null) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_HEARTBEAT_CONNECTION_TYPE_BLANK;
            messages.add(new ValidationMessage(resourceType, ValidationMessageType.Error, code));
        }
        if ((strategyClass = resourceType.getHeartbeatStrategyClass()) == null || strategyClass.trim().length() == 0) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_HEARTBEAT_STRATEGY_BLANK;
            messages.add(new ValidationMessage(resourceType, ValidationMessageType.Error, code));
        } else if (strategyClass.length() > 256) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_HEARTBEAT_STRATEGY_TOO_LONG;
            messages.add(new ValidationMessage(resourceType, ValidationMessageType.Error, code));
        }
    }
}

