/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.resourcetype;

import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagesPropertyRule
implements IValidationRule<ResourceType> {
    @Override
    public List<ValidationMessage> validateRule(ResourceType target) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        this.validateMessages(target, messages);
        return messages;
    }

    private void validateMessages(ResourceType resourceType, List<ValidationMessage> messages) {
        Set<Message> rtMessages = resourceType.getMessages();
        if (rtMessages == null) {
            return;
        }
        HashSet<String> uids = new HashSet<String>();
        HashSet<String> duplicateUids = new HashSet<String>();
        HashSet<String> names = new HashSet<String>();
        HashSet<String> duplicateNames = new HashSet<String>();
        for (Message message : rtMessages) {
            ResourceType containedResourceType = message.getResourceType();
            if (!resourceType.equals(containedResourceType) && containedResourceType != null) {
                ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_MESSAGE_RESOURCE_TYPE_INVALID;
                messages.add(new ValidationMessage(message, ValidationMessageType.Error, code));
            }
            boolean skipUid = false;
            boolean skipName = false;
            String uid = message.getUid();
            String name = message.getName();
            if (message.isUIDGenerationRequired() || uid == null || uid.trim().length() == 0) {
                skipUid = true;
            }
            if (name == null || name.trim().length() == 0) {
                skipName = true;
            } else {
                name = name.trim().toLowerCase();
            }
            if (!skipUid) {
                if (uids.contains(uid)) {
                    duplicateUids.add(uid);
                } else {
                    uids.add(uid);
                }
            }
            if (skipName) continue;
            if (names.contains(name)) {
                duplicateNames.add(message.getName());
                continue;
            }
            names.add(name);
        }
        this.validateDuplicateUIDs(resourceType, duplicateUids, messages);
        this.validateDuplicateNames(resourceType, duplicateNames, messages);
    }

    private void validateDuplicateUIDs(ResourceType resourceType, Set<String> duplicateUids, List<ValidationMessage> messages) {
        for (String uid : duplicateUids) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_UID_DUPLICATES_ERROR;
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(uid);
            messages.add(new ValidationMessage(resourceType, ValidationMessageType.Error, code, parameters));
        }
    }

    private void validateDuplicateNames(ResourceType resourceType, Set<String> duplicateNames, List<ValidationMessage> messages) {
        for (String name : duplicateNames) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_MESSAGE_NAME_DUPLICATES_ERROR;
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(name);
            messages.add(new ValidationMessage(resourceType, ValidationMessageType.Error, code, parameters));
        }
    }
}

